/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation;

import com.sun.xml.txw2.annotation.XmlElement;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.SysConfigData;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.GeoStyle;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.LayerStyle;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.TermStyle;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.Theme;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlSeeAlso(value={Theme.class, LayerStyle.class})
public class SystemPresentationConfig
implements SysConfigData {
    @XmlTransient
    public static final String DEFAULT_THEME = "default";
    @XmlTransient
    public static final String DEFAULT_STYLE = "default";
    private List<Theme> themes = new ArrayList<Theme>();
    private List<LayerStyle> layerStyles = new ArrayList<LayerStyle>();
    @XmlTransient
    private Map<String, Theme> themeLookup = new HashMap<String, Theme>();
    @XmlTransient
    private Map<String, LayerStyle> styleLookup = new HashMap<String, LayerStyle>();

    public List<Theme> getThemes() {
        return this.themes;
    }

    @XmlElement
    public void setThemes(List<Theme> themes) throws Exception {
        this.themes = themes;
        this.themeLookup = new HashMap<String, Theme>();
        for (Theme t : themes) {
            if (t.getTitle() == null) {
                throw new Exception("No title");
            }
            this.themeLookup.put(t.getTitle(), t);
        }
    }

    public Theme getTheme(String name) throws Exception {
        if (name == null) {
            throw new Exception("No theme title");
        }
        return this.themeLookup.get(name);
    }

    public void addTheme(Theme theme) throws Exception {
        if (theme.getTitle() == null) {
            throw new Exception("No title");
        }
        if (theme.getGeoStyle() == null) {
            GeoStyle gs = new GeoStyle();
            gs.setTermStyles(new ArrayList<TermStyle>());
            theme.setGeoStyle(gs);
        }
        if (this.themeLookup.containsKey(theme.getTitle())) {
            this.removeTheme(theme.getTitle());
        }
        this.themeLookup.put(theme.getTitle(), theme);
        this.themes.add(theme);
    }

    public void setupDefaultTheme() throws Exception {
        if (this.themeLookup.get("default") != null) {
            throw new Exception("Default theme already exists");
        }
        Theme def = new Theme();
        def.setTitle("default");
        GeoStyle gs = new GeoStyle();
        gs.setTermStyles(new ArrayList<TermStyle>());
        def.setGeoStyle(gs);
        this.themes.add(def);
    }

    public void removeTheme(String name) throws Exception {
        if (name == null) {
            throw new Exception("No title");
        }
        Theme t = this.themeLookup.get(name);
        if (t != null) {
            this.themeLookup.remove(t);
        }
        this.themes.remove(t);
    }

    public List<LayerStyle> getLayerStyles() {
        return this.layerStyles;
    }

    @XmlElement
    public void setLayerStyles(List<LayerStyle> layerStyles) throws Exception {
        this.layerStyles = layerStyles;
        this.styleLookup = new HashMap<String, LayerStyle>();
        for (LayerStyle s : layerStyles) {
            if (s.getName() == null) {
                throw new Exception("No style name");
            }
            this.styleLookup.put(s.getName(), s);
        }
    }

    public LayerStyle getLayerStyle(String name) throws Exception {
        if (name == null) {
            throw new Exception("No style name");
        }
        return this.styleLookup.get(name);
    }

    public void removeLayerStyle(String name) throws Exception {
        if (name == null) {
            throw new Exception("No style name provided");
        }
        for (Theme t : this.themes) {
            for (TermStyle ts : t.getGeoStyle().getTermStyles()) {
                if (!ts.getStyle().equals(name)) continue;
                throw new Exception("Cannot delete referenced layer style. Reference by: " + ts.getId());
            }
        }
        LayerStyle ls = this.styleLookup.get(name);
        if (ls != null) {
            this.styleLookup.remove(ls);
        }
        this.layerStyles.remove(ls);
    }

    public void addLayerStyle(LayerStyle style) throws Exception {
        if (style == null) {
            throw new Exception("No style provided");
        }
        if (style.getName() == null) {
            throw new Exception("No style name provided");
        }
        if (this.styleLookup.containsKey(style.getName())) {
            this.removeLayerStyle(style.getName());
        }
        this.styleLookup.put(style.getName(), style);
        this.layerStyles.add(style);
    }

    public void updateLayerStyle(LayerStyle style) throws Exception {
        if (style == null) {
            throw new Exception("No style provided");
        }
        if (style.getName() == null) {
            throw new Exception("No style name provided");
        }
        if (!this.styleLookup.containsKey(style.getName())) {
            throw new Exception("Style not found");
        }
        this.styleLookup.put(style.getName(), style);
        this.layerStyles.remove(style);
        this.layerStyles.add(style);
    }

    public String getTermStyle(String theme, String termId) throws Exception {
        if (theme == null) {
            throw new Exception("No theme title");
        }
        if (termId == null) {
            throw new Exception("No term id");
        }
        Theme t = this.themeLookup.get(theme);
        if (t == null) {
            return null;
        }
        TermStyle ts = t.getGeoStyle().getTermStyle(termId);
        if (ts == null) {
            return null;
        }
        return ts.getStyle();
    }

    public String getTermStyle(String termId) throws Exception {
        return this.getTermStyle("default", termId);
    }

    public void assignTermStyle(String theme, String termId, String styleRef) throws Exception {
        Theme t;
        if (theme == null) {
            throw new Exception("No theme title");
        }
        if (termId == null) {
            throw new Exception("No term id");
        }
        if (styleRef == null) {
            throw new Exception("No style name");
        }
        if (this.styleLookup.get(styleRef) == null) {
            throw new Exception("Invalid style reference: " + styleRef);
        }
        if (!this.themeLookup.containsKey(theme)) {
            t = new Theme();
            t.setTitle(theme);
            GeoStyle g = new GeoStyle();
            t.setGeoStyle(g);
            this.themeLookup.put(t.getTitle(), t);
        }
        t = this.themeLookup.get(theme);
        TermStyle ts = new TermStyle();
        ts.setId(termId);
        ts.setStyle(styleRef);
        t.getGeoStyle().addTermStyle(ts);
    }

    public void assignTermStyle(String termId, String styleRef) throws Exception {
        this.assignTermStyle("default", termId, styleRef);
    }

    public void removeTermStyle(String theme, String termId) throws Exception {
        if (theme == null) {
            throw new Exception("No theme title");
        }
        if (termId == null) {
            throw new Exception("No term id");
        }
        Theme t = this.themeLookup.get(theme);
        if (t == null) {
            return;
        }
        t.getGeoStyle().removeTermStyle(termId);
    }

    public void removeTermStyles(String termId) throws Exception {
        for (Theme theme : this.themes) {
            this.removeTermStyle(theme.getTitle(), termId);
        }
    }

    public void removeTermStyle(String termId) throws Exception {
        if (termId == null) {
            throw new Exception("No term id");
        }
        this.removeTermStyle("default", termId);
    }
}

