/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.workflow;

import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.Identifiable;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@javax.persistence.Entity
@Table(name="\"Workflow\"")
public class Workflow
implements Entity,
Identifiable,
Stampable {
    @Id
    @Type(type="org.hibernate.type.PostgresUUIDType")
    @Column(name="\"WF_ID\"", nullable=false)
    private UUID id = null;
    @ManyToOne
    @JoinColumn(name="\"WF_Project\"", nullable=false)
    private Project project = null;
    @ManyToOne
    @JoinColumn(name="\"WF_Template\"", nullable=true)
    private Project template = null;
    @Column(name="\"WF_Name\"", nullable=false, length=250)
    private String name = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"WF_StartDate\"", nullable=true)
    private Date startDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"WF_EndDate\"", nullable=true)
    private Date endDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"WF_ReminderDate\"", nullable=true)
    private Date reminderDate = null;
    @Column(name="\"WF_Status\"", nullable=false)
    private short status = WorkflowStatus.ACTIVE.statusCode();
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"WF_StatusDate\"", nullable=false)
    private Date statusDate = null;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Basic(fetch=FetchType.LAZY)
    @Column(name="\"WF_Description\"", nullable=true)
    private String description = null;
    @Type(type="gr.cite.geoanalytics.dataaccess.typedefinition.XMLType")
    @Basic(fetch=FetchType.LAZY)
    @Column(name="\"WF_ExtraData\"", nullable=true, columnDefinition="xml")
    private String extraData = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"WF_CreationDate\"", nullable=false)
    private Date creationDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"WF_LastUpdate\"", nullable=false)
    private Date lastUpdate = null;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"WF_Creator\"", nullable=false)
    private Principal creator = null;

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getTemplate() {
        return this.template;
    }

    public void setTemplate(Project template) {
        this.template = template;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getReminderDate() {
        return this.reminderDate;
    }

    public void setReminderDate(Date reminderDate) {
        this.reminderDate = reminderDate;
    }

    public WorkflowStatus getStatus() {
        return WorkflowStatus.fromStatusCode(this.status);
    }

    public void setStatus(WorkflowStatus status) {
        this.status = status.statusCode();
    }

    public Date getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Date statusDate) {
        this.statusDate = statusDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Principal getCreator() {
        return this.creator;
    }

    public void setCreator(Principal creator) {
        this.creator = creator;
    }

    public String toString() {
        return "Workflow(id=" + this.getId() + " name=" + this.getName() + " description=" + this.getDescription() + " project=" + (this.project != null ? this.project.getId() : null) + " template=" + (this.template != null ? this.template.getId() : null) + " startDate=" + this.getStartDate() + " endDate=" + this.getEndDate() + " reminderDate=" + this.getReminderDate() + " status=" + (Object)((Object)this.getStatus()) + " statusDate=" + this.getStatusDate() + " extraData=" + this.getExtraData() + " creation=" + this.getCreationDate() + " lastUpdate=" + this.getLastUpdate() + " creator=" + (this.creator != null ? this.creator.getId() : null);
    }

    public static enum WorkflowStatus {
        INACTIVE(0),
        ACTIVE(1),
        COMPLETED(2),
        CANCELLED(3),
        TRANSFERRED(4);

        private final short statusCode;
        private static final Map<Short, WorkflowStatus> lookup;

        private WorkflowStatus(short statusCode) {
            this.statusCode = statusCode;
        }

        public short statusCode() {
            return this.statusCode;
        }

        public static WorkflowStatus fromStatusCode(short statusCode) {
            return lookup.get(statusCode);
        }

        static {
            lookup = new HashMap<Short, WorkflowStatus>();
            for (WorkflowStatus s : EnumSet.allOf(WorkflowStatus.class)) {
                lookup.put(s.statusCode(), s);
            }
        }
    }
}

