/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;

public class ImageGraphicFactory
implements ExternalGraphicFactory {
    private static final Logger LOGGER = Logging.getLogger(ImageGraphicFactory.class);
    static Map<URL, BufferedImage> imageCache = Collections.synchronizedMap(new SoftValueHashMap());
    static Set<String> supportedGraphicFormats = new HashSet<String>(Arrays.asList(ImageIO.getReaderMIMETypes()));

    @Override
    public Icon getIcon(Feature feature, Expression url, String format, int size) {
        if (!supportedGraphicFormats.contains(format.toLowerCase())) {
            return null;
        }
        URL location = url.evaluate(feature, URL.class);
        if (location == null) {
            throw new IllegalArgumentException("The provided expression cannot be evaluated to a URL");
        }
        BufferedImage image = imageCache.get(location);
        if (image == null) {
            try {
                image = ImageIO.read(location);
            }
            catch (IOException ioe) {
                LOGGER.warning("Unable to read image at " + location + " : " + ioe.getMessage());
                return null;
            }
            imageCache.put(location, image);
        }
        if (size > 0 && image.getHeight() != size) {
            double scaleY;
            double dsize = size;
            double scaleX = scaleY = dsize / (double)image.getHeight();
            AffineTransform scaleTx = AffineTransform.getScaleInstance(scaleX, scaleY);
            AffineTransformOp ato = new AffineTransformOp(scaleTx, 2);
            image = ato.filter(image, null);
        }
        return new ImageIcon(image);
    }

    public Set<String> getSupportedMimeTypes() {
        return Collections.unmodifiableSet(supportedGraphicFormats);
    }

    public static void resetCache() {
        imageCache.clear();
    }
}

