/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classifier;

import it.geosolutions.jaiext.classifier.ColorMapTransform;
import it.geosolutions.jaiext.piecewise.Domain1D;
import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;

public class RasterClassifierDescriptor
extends OperationDescriptorImpl {
    private static final long serialVersionUID = 7954257625240335874L;

    public RasterClassifierDescriptor() {
        super(new String[][]{{"GlobalName", "RasterClassifier"}, {"LocalName", "RasterClassifier"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", "Transformation from sample to geophysics values"}, {"DocURL", ""}, {"Version", "1.0"}}, new String[]{"rendered"}, 1, new String[]{"Domain1D", "bandIndex", "roi", "nodata"}, new Class[]{ColorMapTransform.class, Integer.class, ROI.class, Range.class}, new Object[]{NO_PARAMETER_DEFAULT, -1, null, null}, null);
    }

    protected boolean validateParameters(String modeName, ParameterBlock param, StringBuffer message) {
        if (!super.validateParameters(modeName, param, message)) {
            return false;
        }
        RenderedImage source = (RenderedImage)param.getSource(0);
        Domain1D lic = (Domain1D)param.getObjectParameter(0);
        if (lic == null) {
            return false;
        }
        int numBands = source.getSampleModel().getNumBands();
        int bandIndex = param.getIntParameter(1);
        if (bandIndex == -1) {
            return true;
        }
        return bandIndex >= 0 && bandIndex < numBands;
    }

    public RenderedOp create(RenderedImage source0, ColorMapTransform domain1D, Integer bandIndex, ROI roi, Range nodata, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("RasterClassifier", "rendered");
        pb.setSource(source0, 0);
        pb.setParameter("Domain1D", domain1D);
        pb.setParameter("bandIndex", bandIndex);
        pb.setParameter("roi", roi);
        pb.setParameter("nodata", nodata);
        return JAI.create("RasterClassifier", pb, hints);
    }
}

