/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Set;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryFinder;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.resources.LazySet;

public class JTSFactoryFinder
extends FactoryFinder {
    private static FactoryRegistry registry;

    private JTSFactoryFinder() {
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(JTSFactoryFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(GeometryFactory.class));
            registry.registerServiceProvider(new GeometryFactory(), GeometryFactory.class);
        }
        return registry;
    }

    public static synchronized GeometryFactory getGeometryFactory(Hints hints) throws FactoryRegistryException {
        hints = JTSFactoryFinder.mergeSystemHints(hints);
        return JTSFactoryFinder.getServiceRegistry().getServiceProvider(GeometryFactory.class, null, hints, Hints.JTS_GEOMETRY_FACTORY);
    }

    public static synchronized GeometryFactory getGeometryFactory() throws FactoryRegistryException {
        return JTSFactoryFinder.getGeometryFactory(null);
    }

    public static synchronized Set getGeometryFactories() {
        return new LazySet<GeometryFactory>(JTSFactoryFinder.getServiceRegistry().getServiceProviders(GeometryFactory.class, null, null));
    }

    public static synchronized PrecisionModel getPrecisionModel(Hints hints) throws FactoryRegistryException {
        hints = JTSFactoryFinder.mergeSystemHints(hints);
        return JTSFactoryFinder.getServiceRegistry().getServiceProvider(PrecisionModel.class, null, hints, Hints.JTS_PRECISION_MODEL);
    }

    public static synchronized Set getPrecisionModels() {
        return new LazySet<PrecisionModel>(JTSFactoryFinder.getServiceRegistry().getServiceProviders(PrecisionModel.class, null, null));
    }

    public static synchronized CoordinateSequenceFactory getCoordinateSequenceFactory(Hints hints) throws FactoryRegistryException {
        hints = JTSFactoryFinder.mergeSystemHints(hints);
        return JTSFactoryFinder.getServiceRegistry().getServiceProvider(CoordinateSequenceFactory.class, null, hints, Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
    }

    public static synchronized Set getCoordinateSequenceFactories() {
        return new LazySet<CoordinateSequenceFactory>(JTSFactoryFinder.getServiceRegistry().getServiceProviders(CoordinateSequenceFactory.class, null, null));
    }

    public static void scanForPlugins() {
        if (registry != null) {
            registry.scanForPlugins();
        }
    }

    private static final class Registry
    extends FactoryCreator {
        public Registry() {
            super(Arrays.asList(GeometryFactory.class, PrecisionModel.class, CoordinateSequenceFactory.class));
        }

        protected Object createServiceProvider(Class category, Class implementation, Hints hints) throws FactoryRegistryException {
            if (GeometryFactory.class.isAssignableFrom(category) && GeometryFactory.class.equals((Object)implementation)) {
                return new GeometryFactory(JTSFactoryFinder.getPrecisionModel(hints), Registry.getSRID(hints), JTSFactoryFinder.getCoordinateSequenceFactory(hints));
            }
            return super.createServiceProvider(category, implementation, hints);
        }

        private static int getSRID(Hints hints) {
            Integer SRID;
            if (hints != null && (SRID = (Integer)hints.get(Hints.JTS_SRID)) != null) {
                return SRID;
            }
            return 0;
        }

        protected boolean isAcceptable(Object provider, Class category, Hints hints) {
            if (GeometryFactory.class.isAssignableFrom(category)) {
                GeometryFactory factory = (GeometryFactory)provider;
                CoordinateSequenceFactory sequence = factory.getCoordinateSequenceFactory();
                PrecisionModel precision = factory.getPrecisionModel();
                if (!Registry.isAcceptable(sequence, hints.get(Hints.JTS_COORDINATE_SEQUENCE_FACTORY)) || !Registry.isAcceptable(precision, hints.get(Hints.JTS_PRECISION_MODEL))) {
                    return false;
                }
                int SRID = Registry.getSRID(hints);
                if (SRID != 0 && SRID != factory.getSRID()) {
                    return false;
                }
            }
            return super.isAcceptable(provider, category, hints);
        }

        private static boolean isAcceptable(Object actual, Object requested) {
            if (requested == null || requested.equals(actual)) {
                return true;
            }
            if (requested.getClass().isArray()) {
                int length = Array.getLength(requested);
                for (int i = 0; i < length; ++i) {
                    if (Registry.isAcceptable(actual, Array.get(requested, i))) continue;
                    return false;
                }
                return true;
            }
            if (actual != null && requested instanceof Class) {
                return ((Class)requested).isAssignableFrom(actual.getClass());
            }
            return false;
        }
    }
}

