/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.awt.Cursor;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.swing.JMapPane;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.tool.AbstractZoomTool;

public class ScrollWheelTool
extends AbstractZoomTool {
    public ScrollWheelTool(JMapPane mapPane) {
        this.setMapPane(mapPane);
    }

    @Override
    public Cursor getCursor() {
        return null;
    }

    @Override
    public void onMouseWheelMoved(MapMouseEvent ev) {
        Rectangle paneArea = ((JComponent)((Object)this.getMapPane())).getVisibleRect();
        DirectPosition2D mapPos = ev.getWorldPos();
        double scale = this.getMapPane().getWorldToScreenTransform().getScaleX();
        int clicks = ev.getWheelAmount();
        double actualZoom = 1.0;
        actualZoom = clicks > 0 ? -1.0 / ((double)clicks * this.getZoom()) : (double)clicks * this.getZoom();
        double newScale = scale * actualZoom;
        DirectPosition2D corner = new DirectPosition2D(mapPos.getX() - 0.5 * paneArea.getWidth() / newScale, mapPos.getY() + 0.5 * paneArea.getHeight() / newScale);
        Envelope2D newMapArea = new Envelope2D();
        newMapArea.setFrameFromCenter(mapPos, corner);
        this.getMapPane().setDisplayArea(newMapArea);
    }
}

