/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.coordinatesequence;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequence;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.geotools.geometry.jts.coordinatesequence.CSBuilder;

public abstract class PackedCSBuilder
implements CSBuilder {
    int size = -1;
    int dimensions = -1;

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getDimension() {
        return this.dimensions;
    }

    public static class Float
    extends PackedCSBuilder {
        float[] ordinates;
        PackedCoordinateSequenceFactory factory = new PackedCoordinateSequenceFactory(1);

        @Override
        public void start(int size, int dimensions) {
            this.ordinates = new float[size * dimensions];
            this.size = size;
            this.dimensions = dimensions;
        }

        @Override
        public CoordinateSequence end() {
            CoordinateSequence cs = this.factory.create(this.ordinates, this.dimensions);
            this.ordinates = null;
            this.size = -1;
            this.dimensions = -1;
            return cs;
        }

        @Override
        public void setOrdinate(double value, int ordinateIndex, int coordinateIndex) {
            this.ordinates[coordinateIndex * this.dimensions + ordinateIndex] = (float)value;
        }

        @Override
        public void setOrdinate(CoordinateSequence sequence, double value, int ordinateIndex, int coordinateIndex) {
            PackedCoordinateSequence pcs = (PackedCoordinateSequence)sequence;
            pcs.setOrdinate(coordinateIndex, ordinateIndex, value);
        }

        @Override
        public double getOrdinate(int ordinateIndex, int coordinateIndex) {
            return this.ordinates[coordinateIndex * this.dimensions + ordinateIndex];
        }
    }

    public static class Double
    extends PackedCSBuilder {
        double[] ordinates;
        PackedCoordinateSequenceFactory factory = new PackedCoordinateSequenceFactory(0);

        @Override
        public void start(int size, int dimensions) {
            this.ordinates = new double[size * dimensions];
            this.size = size;
            this.dimensions = dimensions;
        }

        @Override
        public CoordinateSequence end() {
            CoordinateSequence cs = this.factory.create(this.ordinates, this.dimensions);
            this.ordinates = null;
            this.size = -1;
            this.dimensions = -1;
            return cs;
        }

        @Override
        public void setOrdinate(double value, int ordinateIndex, int coordinateIndex) {
            this.ordinates[coordinateIndex * this.dimensions + ordinateIndex] = value;
        }

        @Override
        public double getOrdinate(int ordinateIndex, int coordinateIndex) {
            return this.ordinates[coordinateIndex * this.dimensions + ordinateIndex];
        }

        @Override
        public void setOrdinate(CoordinateSequence sequence, double value, int ordinateIndex, int coordinateIndex) {
            PackedCoordinateSequence pcs = (PackedCoordinateSequence)sequence;
            pcs.setOrdinate(coordinateIndex, ordinateIndex, value);
        }
    }
}

