/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import java.math.BigDecimal;
import javax.xml.namespace.QName;
import org.geotools.gml2.GML;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class GMLCoordTypeBinding
extends AbstractComplexBinding {
    CoordinateSequenceFactory csFactory;

    public GMLCoordTypeBinding(CoordinateSequenceFactory csFactory) {
        this.csFactory = csFactory;
    }

    @Override
    public QName getTarget() {
        return GML.CoordType;
    }

    @Override
    public Class getType() {
        return Coordinate.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        int dimension = 1;
        double z = Double.NaN;
        double y = Double.NaN;
        double x = Double.NaN;
        x = ((BigDecimal)node.getChild("X").getValue()).doubleValue();
        if (!node.getChildren("Y").isEmpty()) {
            ++dimension;
            y = ((BigDecimal)node.getChild("Y").getValue()).doubleValue();
        }
        if (!node.getChildren("Z").isEmpty()) {
            ++dimension;
            z = ((BigDecimal)node.getChild("Z").getValue()).doubleValue();
        }
        return new Coordinate(x, y, z);
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        Coordinate c = (Coordinate)object;
        if ("X".equals(name.getLocalPart())) {
            return new Double(c.x);
        }
        if ("Y".equals(name.getLocalPart())) {
            return new Double(c.y);
        }
        if ("Z".equals(name.getLocalPart()) && !new Double(c.z).isNaN()) {
            return new Double(c.z);
        }
        return null;
    }
}

