/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapLayer;
import org.geotools.map.event.MapBoundsListener;
import org.geotools.map.event.MapLayerListListener;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class MapContext
extends MapContent {
    public MapContext() {
        this((CoordinateReferenceSystem)null);
    }

    public MapContext(MapContent content) {
        this(content.getCoordinateReferenceSystem());
        for (Layer layer : content.layers()) {
            this.addLayer(layer);
        }
        this.setAreaOfInterest(content.getViewport().getBounds());
    }

    public MapContext(CoordinateReferenceSystem crs) {
        this(null, null, null, null, null, crs);
    }

    public MapContext(MapLayer[] layers) {
        this(layers, DefaultGeographicCRS.WGS84);
    }

    public MapContext(MapLayer[] layers, CoordinateReferenceSystem crs) {
        this(layers, null, null, null, null, crs);
    }

    public MapContext(MapLayer[] layers, String title, String contextAbstract, String contactInformation, String[] keywords) {
        this(layers, title, contextAbstract, contactInformation, keywords, null);
    }

    public MapContext(MapLayer[] layers, String title, String contextAbstract, String contactInformation, String[] keywords, CoordinateReferenceSystem crs) {
        super(layers, title, contextAbstract, contactInformation, keywords, crs);
    }

    public boolean addLayer(MapLayer mapLayer) {
        this.layers().add(mapLayer.toLayer());
        return true;
    }

    public boolean addLayer(int index, MapLayer mapLayer) {
        Layer layer = mapLayer.toLayer();
        this.layers().add(index, layer);
        return true;
    }

    public void addLayer(FeatureSource featureSource, Style style) {
        this.addLayer(new DefaultMapLayer(featureSource, style, ""));
    }

    public void addLayer(FeatureCollection featureCollection, Style style) {
        FeatureLayer layer = new FeatureLayer(featureCollection, style);
        this.layers().add(layer);
    }

    public void addLayer(Collection collection, Style style) {
        if (!(collection instanceof FeatureCollection)) {
            throw new IllegalArgumentException("FeatureCollection required");
        }
        FeatureCollection featureCollection = (FeatureCollection)((Object)collection);
        this.addLayer(featureCollection, style);
    }

    public void addLayer(GridCoverage gridCoverage, Style style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null");
        }
        if (!(gridCoverage instanceof GridCoverage2D)) {
            throw new UnsupportedOperationException("GridCoverage2D required");
        }
        GridCoverageLayer layer = new GridCoverageLayer((GridCoverage2D)gridCoverage, style);
        this.layers().add(layer);
    }

    public void addLayer(GridCoverage2DReader reader, Style style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null");
        }
        GridReaderLayer layer = new GridReaderLayer(reader, style);
        this.layers().add(layer);
    }

    public boolean removeLayer(MapLayer layer) {
        int index = this.indexOf(layer);
        if (index == -1) {
            return false;
        }
        this.removeLayer(index);
        return true;
    }

    public MapLayer removeLayer(int index) {
        Layer removed = this.layers().remove(index);
        return new DefaultMapLayer(removed);
    }

    public int addLayers(MapLayer[] array) {
        if (array == null || array.length == 0) {
            return 0;
        }
        return super.addLayers(this.toLayerList(array));
    }

    public void removeLayers(MapLayer[] array) {
        if (array == null || array.length == 0 || this.layers().isEmpty()) {
            return;
        }
        List<Layer> layersToRemove = this.toLayerList(array);
        this.layers().removeAll(layersToRemove);
    }

    public void clearLayerList() {
        this.layers().clear();
    }

    public MapLayer[] getLayers() {
        MapLayer[] array = new MapLayer[this.layers().size()];
        int index = 0;
        for (Layer layer : this.layers()) {
            array[index] = new DefaultMapLayer(layer);
            ++index;
        }
        return array;
    }

    public MapLayer getLayer(int index) throws IndexOutOfBoundsException {
        Layer layer = this.layers().get(index);
        return new DefaultMapLayer(layer);
    }

    @Override
    public void moveLayer(int sourcePosition, int destPosition) {
        super.moveLayer(sourcePosition, destPosition);
    }

    public Iterator<MapLayer> iterator() {
        final Iterator<Layer> iter = this.layers().iterator();
        return new Iterator<MapLayer>(){

            @Override
            public void remove() {
                iter.remove();
            }

            @Override
            public MapLayer next() {
                Layer layer = (Layer)iter.next();
                if (layer == null) {
                    return null;
                }
                return new DefaultMapLayer(layer);
            }

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }
        };
    }

    public int indexOf(MapLayer mapLayer) {
        Layer layer = mapLayer.toLayer();
        return this.layers().indexOf(layer);
    }

    public int getLayerCount() {
        return this.layers().size();
    }

    public ReferencedEnvelope getLayerBounds() throws IOException {
        ReferencedEnvelope maxBounds = null;
        CoordinateReferenceSystem mapCRS = this.viewport != null ? this.viewport.getCoordinateReferenceSystem() : null;
        for (Layer layer : this.layers()) {
            ReferencedEnvelope dataBounds;
            block7: {
                if (layer == null || (dataBounds = layer.getBounds()) == null) continue;
                try {
                    CoordinateReferenceSystem dataCrs = dataBounds.getCoordinateReferenceSystem();
                    if (dataCrs != null && mapCRS != null && !CRS.equalsIgnoreMetadata(dataCrs, mapCRS)) {
                        dataBounds = dataBounds.transform(mapCRS, true);
                    }
                    if (dataCrs != null || mapCRS == null) break block7;
                    LOGGER.log(Level.SEVERE, "It was not possible to get a projected bounds estimate");
                }
                catch (FactoryException e) {
                    LOGGER.log(Level.SEVERE, "Data source and map context coordinate system differ, yet it was not possible to get a projected bounds estimate...", e);
                    continue;
                }
                catch (TransformException e) {
                    LOGGER.log(Level.SEVERE, "Data source and map context coordinate system differ, yet it was not possible to get a projected bounds estimate...", e);
                    continue;
                }
            }
            if (maxBounds == null) {
                maxBounds = dataBounds;
            } else {
                maxBounds.expandToInclude(dataBounds);
            }
            if (mapCRS != null) continue;
            mapCRS = dataBounds.getCoordinateReferenceSystem();
        }
        return maxBounds;
    }

    @Override
    public void addMapLayerListListener(MapLayerListListener listener) {
        super.addMapLayerListListener(listener);
    }

    @Override
    public void removeMapLayerListListener(MapLayerListListener listener) {
        super.removeMapLayerListListener(listener);
    }

    public void setAreaOfInterest(Envelope areaOfInterest, CoordinateReferenceSystem crs) throws IllegalArgumentException {
        this.getViewport().setBounds(new ReferencedEnvelope(areaOfInterest, crs));
    }

    public void setAreaOfInterest(ReferencedEnvelope bounds) throws IllegalArgumentException {
        if (bounds == null) {
            throw new NullPointerException("bounds must not be null");
        }
        this.getViewport().setBounds(bounds);
    }

    public ReferencedEnvelope getAreaOfInterest() {
        return this.getViewport().getBounds();
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return super.getCoordinateReferenceSystem();
    }

    public void transform(AffineTransform transform) {
        ReferencedEnvelope oldBounds = this.getAreaOfInterest();
        if (oldBounds != null && !oldBounds.isEmpty()) {
            double[] coords = new double[]{oldBounds.getMinX(), oldBounds.getMinY(), oldBounds.getMaxX(), oldBounds.getMaxY()};
            transform.transform(coords, 0, coords, 0, 2);
            ReferencedEnvelope newBounds = new ReferencedEnvelope(coords[0], coords[2], coords[1], coords[3], oldBounds.getCoordinateReferenceSystem());
            this.setAreaOfInterest(newBounds);
        }
    }

    @Override
    public void addMapBoundsListener(MapBoundsListener listener) {
        super.addMapBoundsListener(listener);
    }

    @Override
    public void removeMapBoundsListener(MapBoundsListener listener) {
        super.removeMapBoundsListener(listener);
    }

    public String getAbstract() {
        String description = (String)this.getUserData().get("abstract");
        return description == null ? "" : description;
    }

    public void setAbstract(String contextAbstract) {
        this.getUserData().put("abstract", contextAbstract);
    }

    public String getContactInformation() {
        String contact = (String)this.getUserData().get("contact");
        return contact == null ? "" : contact;
    }

    public void setContactInformation(String contactInformation) {
        this.getUserData().put("contact", contactInformation);
    }

    @Override
    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this.getViewport().setCoordinateReferenceSystem(crs);
    }

    public String[] getKeywords() {
        Object obj = this.getUserData().get("keywords");
        if (obj == null) {
            return new String[0];
        }
        if (obj instanceof String) {
            String keywords = (String)obj;
            return keywords.split(",");
        }
        if (obj instanceof String[]) {
            String[] keywords = (String[])obj;
            String[] copy = new String[keywords.length];
            System.arraycopy(keywords, 0, copy, 0, keywords.length);
            return copy;
        }
        if (obj instanceof Collection) {
            Collection keywords = (Collection)obj;
            return keywords.toArray(new String[keywords.size()]);
        }
        return new String[0];
    }

    public void setKeywords(String[] keywords) {
        this.getUserData().put("keywords", keywords);
    }

    @Override
    public String getTitle() {
        return super.getTitle();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
    }

    protected List<Layer> toLayerList(MapLayer[] array) {
        ArrayList<Layer> list = new ArrayList<Layer>();
        for (MapLayer mapLayer : array) {
            Layer layer = mapLayer.toLayer();
            list.add(layer);
        }
        return list;
    }
}

