/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.swing.Icon;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.IconStyle2D;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.Style2D;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class RendererUtilities {
    private static final Logger LOGGER = Logging.getLogger(RendererUtilities.class.getName());
    static boolean SCALE_UNIT_COMPENSATION = Boolean.parseBoolean(System.getProperty("org.geotoools.render.lite.scale.unitCompensation", "true"));
    private static final ThreadLocal<GridToEnvelopeMapper> gridToEnvelopeMappers = new ThreadLocal<GridToEnvelopeMapper>(){

        @Override
        protected GridToEnvelopeMapper initialValue() {
            GridToEnvelopeMapper mapper = new GridToEnvelopeMapper();
            mapper.setPixelAnchor(PixelInCell.CELL_CORNER);
            return mapper;
        }
    };
    static final double OGC_DEGREE_TO_METERS = 111319.49079327358;

    private RendererUtilities() {
    }

    public static AffineTransform worldToScreenTransform(Envelope mapExtent, Rectangle paintArea) {
        double scaleX = paintArea.getWidth() / mapExtent.getWidth();
        double scaleY = paintArea.getHeight() / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + paintArea.getHeight();
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        AffineTransform originTranslation = AffineTransform.getTranslateInstance(paintArea.x, paintArea.y);
        originTranslation.concatenate(at);
        return originTranslation != null ? originTranslation : at;
    }

    public static AffineTransform worldToScreenTransform(ReferencedEnvelope mapExtent, Rectangle paintArea) {
        Envelope2D genvelope = new Envelope2D(mapExtent);
        GridToEnvelopeMapper m = gridToEnvelopeMappers.get();
        try {
            m.setGridRange(new GridEnvelope2D(paintArea));
            m.setEnvelope(genvelope);
            return m.createAffineTransform().createInverse();
        }
        catch (MismatchedDimensionException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            return null;
        }
        catch (NoninvertibleTransformException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static Envelope createMapEnvelope(Rectangle paintArea, AffineTransform worldToScreen) throws NoninvertibleTransformException {
        double[] pts = new double[]{paintArea.getMinX(), paintArea.getMinY(), paintArea.getMaxX(), paintArea.getMinY(), paintArea.getMaxX(), paintArea.getMaxY(), paintArea.getMinX(), paintArea.getMaxY()};
        worldToScreen.inverseTransform(pts, 0, pts, 0, 4);
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        double yMax = -1.7976931348623157E308;
        for (int i = 0; i < 4; ++i) {
            xMin = Math.min(xMin, pts[2 * i]);
            yMin = Math.min(yMin, pts[2 * i + 1]);
            xMax = Math.max(xMax, pts[2 * i]);
            yMax = Math.max(yMax, pts[2 * i + 1]);
        }
        return new Envelope(xMin, xMax, yMin, yMax);
    }

    public static ReferencedEnvelope createMapEnvelope(Rectangle paintArea, AffineTransform worldToScreen, CoordinateReferenceSystem crs) throws NoninvertibleTransformException {
        SingleCRS crs2d = CRS.getHorizontalCRS(crs);
        if (crs2d == null) {
            throw new UnsupportedOperationException(Errors.format(29, crs));
        }
        Envelope env = RendererUtilities.createMapEnvelope(paintArea, worldToScreen);
        return new ReferencedEnvelope(env, (CoordinateReferenceSystem)crs2d);
    }

    public static double calculateScale(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem, int imageWidth, int imageHeight, double DPI) throws TransformException, FactoryException {
        SingleCRS tempCRS = CRS.getHorizontalCRS(coordinateReferenceSystem);
        if (tempCRS == null) {
            throw new TransformException(Errors.format(29, coordinateReferenceSystem));
        }
        double[] cs = new double[4];
        double[] csLatLong = new double[4];
        Coordinate p1 = new Coordinate(envelope.getMinX(), envelope.getMinY());
        Coordinate p2 = new Coordinate(envelope.getMaxX(), envelope.getMaxY());
        cs[0] = p1.x;
        cs[1] = p1.y;
        cs[2] = p2.x;
        cs[3] = p2.y;
        MathTransform transform = CRS.findMathTransform(tempCRS, DefaultGeographicCRS.WGS84, true);
        transform.transform(cs, 0, csLatLong, 0, 2);
        if (csLatLong[0] < -180.0 || csLatLong[0] > 180.0 || csLatLong[2] < -180.0 || csLatLong[2] > 180.0 || csLatLong[1] < -90.0 || csLatLong[1] > 90.0 || csLatLong[3] < -90.0 || csLatLong[3] > 90.0) {
            if (csLatLong[0] > csLatLong[2] || csLatLong[1] > csLatLong[3]) {
                throw new IllegalArgumentException("BBox is backwards");
            }
            if ((csLatLong[0] < -180.0 || csLatLong[0] > 180.0) && (csLatLong[2] < -180.0 || csLatLong[2] > 180.0) && (csLatLong[1] < -90.0 || csLatLong[1] > 90.0) && (csLatLong[3] < -90.0 || csLatLong[3] > 90.0)) {
                throw new IllegalArgumentException("World isn't in the requested bbox");
            }
            double[] newCsLatLong = new double[]{Math.min(Math.max(csLatLong[0], -180.0), 180.0), Math.min(Math.max(csLatLong[1], -90.0), 90.0), Math.min(Math.max(csLatLong[2], -180.0), 180.0), Math.min(Math.max(csLatLong[3], -90.0), 90.0)};
            double[] origProject = new double[4];
            transform.transform(newCsLatLong, 0, origProject, 0, 2);
            double image_min_x = (origProject[0] - envelope.getMinX()) / envelope.getWidth() * (double)imageWidth;
            double image_max_x = (origProject[2] - envelope.getMinX()) / envelope.getWidth() * (double)imageWidth;
            double image_min_y = (origProject[1] - envelope.getMinY()) / envelope.getHeight() * (double)imageHeight;
            double image_max_y = (origProject[3] - envelope.getMinY()) / envelope.getHeight() * (double)imageHeight;
            double distance_ground = JTS.orthodromicDistance(new Coordinate(newCsLatLong[0], newCsLatLong[1]), new Coordinate(newCsLatLong[2], newCsLatLong[3]), DefaultGeographicCRS.WGS84);
            double pixel_distance = Math.sqrt((image_max_x - image_min_x) * (image_max_x - image_min_x) + (image_max_y - image_min_y) * (image_max_y - image_min_y));
            double pixel_distance_m = pixel_distance / DPI * 2.54 / 100.0;
            return distance_ground / pixel_distance_m;
        }
        double diagonalGroundDistance = JTS.orthodromicDistance(new Coordinate(csLatLong[0], csLatLong[1]), new Coordinate(csLatLong[2], csLatLong[3]), DefaultGeographicCRS.WGS84);
        double diagonalPixelDistancePixels = Math.sqrt(imageWidth * imageWidth + imageHeight * imageHeight);
        double diagonalPixelDistanceMeters = diagonalPixelDistancePixels / DPI * 2.54 / 100.0;
        return diagonalGroundDistance / diagonalPixelDistanceMeters;
    }

    public static double calculatePixelsPerMeterRatio(double scaleDenominator, Map hints) {
        if (scaleDenominator <= 0.0) {
            throw new IllegalArgumentException("The scale denominator must be positive.");
        }
        double scale = 1.0 / scaleDenominator;
        return scale * (RendererUtilities.getDpi(hints) / 0.0254);
    }

    public static double calculateOGCScale(ReferencedEnvelope envelope, int imageWidth, Map hints) {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        double width = envelope.getWidth();
        double widthMeters = RendererUtilities.toMeters(width, crs);
        return widthMeters / ((double)imageWidth / RendererUtilities.getDpi(hints) * 0.0254);
    }

    private static double toMeters(double size, CoordinateReferenceSystem crs) {
        Unit<Length> unit;
        if (crs == null) {
            LOGGER.finer("toMeters: assuming the original size is in meters already, as crs is null");
            return size;
        }
        if (crs instanceof GeographicCRS) {
            return size * 111319.49079327358;
        }
        if (!SCALE_UNIT_COMPENSATION) {
            return size;
        }
        SingleCRS horizontal = CRS.getHorizontalCRS(crs);
        if (horizontal != null) {
            crs = horizontal;
        }
        if ((unit = crs.getCoordinateSystem().getAxis(0).getUnit()) == null) {
            LOGGER.finer("toMeters: assuming the original size is in meters already, as the first crs axis unit is null. CRS is " + crs);
            return size;
        }
        if (!unit.isCompatible(SI.METER)) {
            LOGGER.warning("toMeters: could not convert unit " + unit + " to meters");
            return size;
        }
        return unit.getConverterTo(SI.METER).convert(size);
    }

    public static double calculateOGCScaleAffine(CoordinateReferenceSystem crs, AffineTransform worldToScreen, Map hints) {
        double scale = XAffineTransform.getScale(worldToScreen);
        if (crs instanceof GeographicCRS) {
            return 111319.49079327358 * RendererUtilities.getDpi(hints) / (scale * 0.0254);
        }
        return RendererUtilities.getDpi(hints) / (scale * 0.0254);
    }

    public static double calculateScale(ReferencedEnvelope envelope, int imageWidth, int imageHeight, Map hints) throws TransformException, FactoryException {
        if (hints != null && hints.containsKey("declaredScaleDenominator")) {
            Double scale = (Double)hints.get("declaredScaleDenominator");
            if (scale <= 0.0) {
                throw new IllegalArgumentException("the declaredScaleDenominator must be greater than 0, was: " + scale);
            }
            return scale;
        }
        return RendererUtilities.calculateScale(envelope, imageWidth, imageHeight, RendererUtilities.getDpi(hints));
    }

    public static double getDpi(Map hints) {
        if (hints != null && hints.containsKey("dpi")) {
            return ((Number)hints.get("dpi")).doubleValue();
        }
        return 90.7142857142857;
    }

    public static double calculateScale(ReferencedEnvelope envelope, int imageWidth, int imageHeight, double DPI) throws TransformException, FactoryException {
        double diagonalGroundDistance;
        if (!(envelope.getCoordinateReferenceSystem() instanceof EngineeringCRS)) {
            SingleCRS tempCRS = CRS.getHorizontalCRS(envelope.getCoordinateReferenceSystem());
            if (tempCRS == null) {
                throw new TransformException(Errors.format(29, envelope.getCoordinateReferenceSystem()));
            }
            ReferencedEnvelope envelopeWGS84 = envelope.transform(DefaultGeographicCRS.WGS84, true);
            diagonalGroundDistance = RendererUtilities.geodeticDiagonalDistance(envelopeWGS84);
        } else {
            diagonalGroundDistance = Math.sqrt(envelope.getWidth() * envelope.getWidth() + envelope.getHeight() * envelope.getHeight());
        }
        double diagonalPixelDistancePixels = Math.sqrt(imageWidth * imageWidth + imageHeight * imageHeight);
        double diagonalPixelDistanceMeters = diagonalPixelDistancePixels / DPI * 2.54 / 100.0;
        return diagonalGroundDistance / diagonalPixelDistanceMeters;
    }

    private static double geodeticDiagonalDistance(Envelope env) {
        if (env.getWidth() < 180.0 && env.getHeight() < 180.0) {
            return RendererUtilities.getGeodeticSegmentLength(env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY());
        }
        double distance = 0.0;
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(env.getMinX(), env.getMinY()), new Coordinate(env.getMaxX(), env.getMaxY())});
        int qMinX = -1;
        int qMaxX = 1;
        int qMinY = -1;
        int qMaxY = 1;
        qMinX = Math.min(qMinX, (int)(Math.signum(env.getMinX()) * Math.ceil(Math.abs(env.getMinX() / 180.0))));
        qMaxX = Math.max(qMaxX, (int)(Math.signum(env.getMaxX()) * Math.ceil(Math.abs(env.getMaxX() / 180.0))));
        qMinY = Math.min(qMinY, (int)(Math.signum(env.getMinY()) * Math.ceil(Math.abs((env.getMinY() + 90.0) / 180.0))));
        qMaxY = Math.max(qMaxY, (int)(Math.signum(env.getMaxY()) * Math.ceil(Math.abs((env.getMaxY() + 90.0) / 180.0))));
        for (int i = qMinX; i < qMaxX; ++i) {
            for (int j = qMinY; j < qMaxY; ++j) {
                double minX = (double)i * 180.0;
                double minY = (double)j * 180.0 - 90.0;
                double maxY = minY + 180.0;
                double maxX = minX + 180.0;
                LinearRing ring = gf.createLinearRing(new Coordinate[]{new Coordinate(minX, minY), new Coordinate(minX, maxY), new Coordinate(maxX, maxY), new Coordinate(maxX, minY), new Coordinate(minX, minY)});
                Polygon p = gf.createPolygon(ring, null);
                Geometry intersection = p.intersection(ls);
                if (intersection.isEmpty()) continue;
                if (intersection instanceof LineString) {
                    LineString ils = (LineString)intersection;
                    double d = RendererUtilities.getGeodeticSegmentLength(ils);
                    distance += d;
                    continue;
                }
                if (!(intersection instanceof GeometryCollection)) continue;
                GeometryCollection igc = (GeometryCollection)intersection;
                for (int k = 0; k < igc.getNumGeometries(); ++k) {
                    Geometry child = igc.getGeometryN(k);
                    if (!(child instanceof LineString)) continue;
                    double d = RendererUtilities.getGeodeticSegmentLength((LineString)child);
                    distance += d;
                }
            }
        }
        return distance;
    }

    private static double getGeodeticSegmentLength(LineString ls) {
        Coordinate start = ls.getCoordinateN(0);
        Coordinate end = ls.getCoordinateN(1);
        return RendererUtilities.getGeodeticSegmentLength(start.x, start.y, end.x, end.y);
    }

    private static double getGeodeticSegmentLength(double minx, double miny, double maxx, double maxy) {
        GeodeticCalculator calculator = new GeodeticCalculator(DefaultGeographicCRS.WGS84);
        double rminx = RendererUtilities.rollLongitude(minx);
        double rminy = RendererUtilities.rollLatitude(miny);
        double rmaxx = RendererUtilities.rollLongitude(maxx);
        double rmaxy = RendererUtilities.rollLatitude(maxy);
        calculator.setStartingGeographicPoint(rminx, rminy);
        calculator.setDestinationGeographicPoint(rmaxx, rmaxy);
        return calculator.getOrthodromicDistance();
    }

    protected static double rollLongitude(double x) {
        double rolled = x - (double)((int)(x + Math.signum(x) * 180.0) / 360) * 360.0;
        return rolled;
    }

    protected static double rollLatitude(double x) {
        double rolled = x - (double)((int)(x + Math.signum(x) * 90.0) / 180) * 180.0;
        return rolled;
    }

    public static AffineTransform worldToScreenTransform(Envelope mapExtent, Rectangle paintArea, CoordinateReferenceSystem destinationCrs) throws TransformException {
        SingleCRS crs2D = CRS.getHorizontalCRS(destinationCrs);
        if (crs2D == null) {
            throw new TransformException(Errors.format(29, destinationCrs));
        }
        boolean lonFirst = crs2D.getCoordinateSystem().getAxis(0).getDirection().absolute().equals(AxisDirection.EAST);
        GeneralEnvelope newEnvelope = lonFirst ? new GeneralEnvelope(new double[]{mapExtent.getMinX(), mapExtent.getMinY()}, new double[]{mapExtent.getMaxX(), mapExtent.getMaxY()}) : new GeneralEnvelope(new double[]{mapExtent.getMinY(), mapExtent.getMinX()}, new double[]{mapExtent.getMaxY(), mapExtent.getMaxX()});
        newEnvelope.setCoordinateReferenceSystem(destinationCrs);
        GridToEnvelopeMapper m = gridToEnvelopeMappers.get();
        m.setGridRange(new GridEnvelope2D(paintArea));
        m.setEnvelope(newEnvelope);
        return (AffineTransform)((Object)m.createTransform().inverse());
    }

    public static Geometry getCentroid(Geometry g) {
        if (g instanceof Point || g instanceof MultiPoint) {
            return g;
        }
        if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            Coordinate[] pts = new Coordinate[gc.getNumGeometries()];
            int length = gc.getNumGeometries();
            for (int t = 0; t < length; ++t) {
                pts[t] = RendererUtilities.pointInGeometry(gc.getGeometryN(t)).getCoordinate();
            }
            return g.getFactory().createMultiPoint(pts);
        }
        if (g != null) {
            return RendererUtilities.pointInGeometry(g);
        }
        return null;
    }

    private static Geometry pointInGeometry(Geometry g) {
        Point p = g.getCentroid();
        if (g instanceof Polygon) {
            if (Double.isNaN(p.getX()) || Double.isNaN(p.getY())) {
                return g.getFactory().createPoint(g.getCoordinate());
            }
            if (g.isValid() && !g.contains(p)) {
                try {
                    p = g.getInteriorPoint();
                }
                catch (Exception e) {
                    return p;
                }
            } else {
                return p;
            }
        }
        return p;
    }

    public static double getStyle2DSize(Style2D style) {
        if (style instanceof GraphicStyle2D) {
            BufferedImage image = ((GraphicStyle2D)style).getImage();
            return RendererUtilities.maxSize(image.getWidth(), image.getHeight());
        }
        if (style instanceof IconStyle2D) {
            Icon icon = ((IconStyle2D)style).getIcon();
            return RendererUtilities.maxSize(icon.getIconWidth(), icon.getIconHeight());
        }
        if (style instanceof LineStyle2D) {
            LineStyle2D ls = (LineStyle2D)style;
            double gsSize = RendererUtilities.getStyle2DSize(ls.getGraphicStroke());
            double strokeSize = 0.0;
            if (ls.getStroke() instanceof BasicStroke) {
                strokeSize = ((BasicStroke)ls.getStroke()).getLineWidth();
            }
            double offset = ls.getPerpendicularOffset();
            return RendererUtilities.maxSize(RendererUtilities.maxSize(gsSize, strokeSize), offset);
        }
        return 0.0;
    }

    private static double maxSize(double d1, double d2) {
        if (Double.isNaN(d1)) {
            d1 = 0.0;
        }
        if (Double.isNaN(d2)) {
            d2 = 0.0;
        }
        return Math.max(d1, d2);
    }

    static FeatureCollection fixFeatureCollectionReferencing(FeatureCollection features, CoordinateReferenceSystem sourceCrs) {
        CoordinateReferenceSystem rCS = null;
        try {
            rCS = features.getSchema().getGeometryDescriptor().getType().getCoordinateReferenceSystem();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!(rCS == sourceCrs || sourceCrs == null || rCS != null && CRS.equalsIgnoreMetadata(rCS, sourceCrs))) {
            try {
                return new ForceCoordinateSystemFeatureResults((SimpleFeatureCollection)features, sourceCrs);
            }
            catch (Exception ee) {
                LOGGER.log(Level.WARNING, ee.getLocalizedMessage(), ee);
            }
        }
        return features;
    }
}

