package gr.cite.geoanalytics.environmental.data.retriever.model;

public class Data {

	protected String date;

	protected double latitude;
	protected double longitude;

	protected float value;

	public Data() {}

	public Data(Data other) {
		this.date = other.getDate();
		this.value = other.getValue();
		this.latitude = other.getLatitude();
		this.longitude = other.getLongitude();
	}

	public int getValueAsInt() {
		return (int) Math.round(value);
	}

	public float getValue() {
		return value;
	}
	
	public int getValueAsInt(Unit unit) {
		return (int) Math.round(value);
	}

	public float getValue(Unit unit) {
		return value;
	}
	
	public void setValue(float value) {
		this.value = value;
	}

	public String getDate() {
		return date;
	}

	public void setDate(String date) {
		this.date = date;
	}

	public double getLatitude() {
		return latitude;
	}

	public void setLatitude(double latitude) {
		this.latitude = latitude;
	}

	public double getLongitude() {
		return longitude;
	}

	public void setLongitude(double longitude) {
		this.longitude = longitude;
	}

	@Override
	public String toString() {
		return "[ Date " + date + ",  Latitude " + longitude + " , Longitude " + latitude + ", " + " Value  = " + value + " ]";
	}
}
