/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFixedFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDFixedFacetImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDMinLengthFacetImpl
extends XSDFixedFacetImpl
implements XSDMinLengthFacet {
    protected static final int VALUE_EDEFAULT = 0;
    protected int value = 0;

    public static XSDMinLengthFacet createMinLengthFacet(Node node) {
        if (XSDConstants.nodeType(node) == 28) {
            XSDMinLengthFacet xsdMinLengthFacet = XSDFactory.eINSTANCE.createXSDMinLengthFacet();
            xsdMinLengthFacet.setElement((Element)node);
            return xsdMinLengthFacet;
        }
        return null;
    }

    protected XSDMinLengthFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_MIN_LENGTH_FACET;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int newValue) {
        int oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 11, oldValue, this.value));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.setValue((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.setValue(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return this.value != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    public Element createElement() {
        Element newElement = this.createElement(28);
        this.setElement(newElement);
        return newElement;
    }

    public void validate() {
        super.validate();
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = this.getSimpleTypeDefinition();
        XSDMaxLengthFacet xsdMaxLengthFacet = xsdSimpleTypeDefinition.getEffectiveMaxLengthFacet();
        if (xsdMaxLengthFacet != null && this.getValue() > xsdMaxLengthFacet.getValue()) {
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "minLength-less-than-equal-to-maxLength", this.getElement(), null, new Object[]{this.getValue(), xsdMaxLengthFacet.getEffectiveValue()});
            xsdDiagnostic.getComponents().add(xsdMaxLengthFacet);
        }
    }

    protected void validateRestriction(XSDFixedFacet xsdFixedFacet) {
        if (this.getValue() < ((XSDMinLengthFacet)xsdFixedFacet).getValue()) {
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "minLength-valid-restriction", this.getElement(), "value", new Object[]{this.getValue(), xsdFixedFacet.getEffectiveValue(), xsdFixedFacet.getSimpleTypeDefinition().getURI()});
            xsdDiagnostic.getComponents().add(xsdFixedFacet);
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        if (eAttribute == XSDPackage.Literals.XSD_FACET__LEXICAL_VALUE) {
            if (this.getLexicalValue() == null) {
                this.setValue(0);
            } else {
                try {
                    int newValue = Integer.parseInt(this.getLexicalValue());
                    if (newValue != this.getValue()) {
                        this.setValue(newValue);
                    }
                }
                catch (NumberFormatException exception) {
                    this.setValue(0);
                }
            }
            this.traverseToRootForAnalysis();
        }
    }

    public boolean isConstraintSatisfied(Object value) {
        if (value instanceof List) {
            return ((List)value).size() >= this.getValue();
        }
        if (value instanceof String) {
            return ((String)value).length() >= this.getValue();
        }
        if (value instanceof XSDUtil.ByteSequence) {
            return ((XSDUtil.ByteSequence)value).getBytes().length >= this.getValue();
        }
        if (value instanceof QName) {
            QName qName = (QName)value;
            int size = qName.getPrefix().length();
            if (size > 0) {
                ++size;
            }
            return (size += qName.getLocalPart().length()) >= this.getValue();
        }
        return false;
    }

    public Object getEffectiveValue() {
        return this.getValue();
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDMinLengthFacetImpl clonedMinLengthFacet = (XSDMinLengthFacetImpl)this.getXSDFactory().createXSDMinLengthFacet();
        clonedMinLengthFacet.isReconciling = true;
        if (this.getLexicalValue() != null) {
            clonedMinLengthFacet.setLexicalValue(this.getLexicalValue());
        }
        if (this.isSetFixed()) {
            clonedMinLengthFacet.setFixed(this.isFixed());
        }
        if (deep && this.getAnnotation() != null) {
            clonedMinLengthFacet.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedMinLengthFacet.setElement(this.getElement());
        }
        clonedMinLengthFacet.isReconciling = shareDOM;
        return clonedMinLengthFacet;
    }
}

