drop view SimulModelFullView;
create view SimulModelFullView as (
select 
	sm.*,
	sp.designation as speciesDesignation,
	si.designation as siteDesignation,
	bq.designation as broodstockQualityDesignation,
	fq.designation as feedQualityDesignation
from 
	SimulModel sm
	join Species sp on (sm.id=sp.id)
	join Site si on (sm.siteId=si.id)
	join BroodstockQuality bq on (sm.id=bq.id)
	join FeedQuality fq on (sm.id=fq.id)
);

drop view ScenarioFullView;
create view ScenarioFullView as (
select 
	sn.*,
	sm.designation as simulModelDesignation
from 
	Scenario sn
	join SimulModel sm on (sn.simulModelId=sm.id)
);

drop view SiteFullView;
create view SiteFullView as (
select 
	si.*,
	rg.designation as regionDesignation,
	oxr.designation as oxygenRatingDesignation,
	cr.designation as currentRatingDesignation
from 
	Site si
	join Region rg on (si.id=rg.id)
	join OxygenRating oxr on (si.id=oxr.id)
	join CurrentRating cr on (si.id=cr.id)
);

delete from BroodstockQuality;
insert into BroodstockQuality (id, aa, designation) values (1, 1, "bq*");
insert into BroodstockQuality (id, aa, designation) values (2, 2, "bq**");
insert into BroodstockQuality (id, aa, designation) values (3, 3, "bq***");
insert into BroodstockQuality (id, aa, designation) values (4, 4, "bq****");
insert into BroodstockQuality (id, aa, designation) values (5, 5, "bq*****");

delete from FeedQuality;
insert into FeedQuality (id, aa, designation) values (1, 1, "fq*");
insert into FeedQuality (id, aa, designation) values (2, 2, "fq**");
insert into FeedQuality (id, aa, designation) values (3, 3, "fq***");
insert into FeedQuality (id, aa, designation) values (4, 4, "fq****");
insert into FeedQuality (id, aa, designation) values (5, 5, "fq*****");

delete from OxygenRating;
insert into OxygenRating (id, aa, designation) values (1, 1, "or*");
insert into OxygenRating (id, aa, designation) values (2, 2, "or**");
insert into OxygenRating (id, aa, designation) values (3, 3, "or***");
insert into OxygenRating (id, aa, designation) values (4, 4, "or****");
insert into OxygenRating (id, aa, designation) values (5, 5, "or*****");

delete from CurrentRating;
insert into CurrentRating (id, aa, designation) values (1, 1, "cr*");
insert into CurrentRating (id, aa, designation) values (2, 2, "cr**");
insert into CurrentRating (id, aa, designation) values (3, 3, "cr***");
insert into CurrentRating (id, aa, designation) values (4, 4, "cr****");
insert into CurrentRating (id, aa, designation) values (5, 5, "cr*****");

delete from Region;
insert into Region (id,	designation) values (1, "Greece");
insert into Region (id,	designation) values (2, "Morocco");
insert into Region (id,	designation) values (3, "Suridesignation");

delete from Species;
insert into Species (id, designation) values (1, "Sea bass");
insert into Species (id, designation) values (2, "Sea bream");