package gr.i2s.bluebridge.simul.model.util;

import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gr.i2s.bluebridge.simul.model.ModelerFull;
import gr.i2s.bluebridge.simul.util2.HibernateUtil;

public class ModelerFullUtil {
	public static void add(ModelerFull modelerFull) throws Exception {
		ModelerUtil.add(modelerFull);
	}

	public static void update(ModelerFull modelerFull) throws Exception {
		ModelerUtil.update(modelerFull);
	}

	public static void delete(long id) throws Exception {
		ModelerUtil.delete(id);
	}

	public static ModelerFull getModelerFull(long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			ModelerFull modelerFull = (ModelerFull) session.get(ModelerFull.class, Long.valueOf(id));

			session.getTransaction().commit();

			return modelerFull;
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static List getModelerFulls(String userId, int start, int end) throws Exception {
		if (logger.isTraceEnabled()) {
			logger.trace(String.format("reading %s for %s start %s end %s", "ModelerFull", userId, start, end));
		}

		Session session = null;

		try {
			logger.trace(String.format("denispyr start getModelerFulls"));
			session = HibernateUtil.openSession();
			logger.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_USERID).setParameter("userid", userId);
			if (start > 0)
				q.setFirstResult(start);
			if (end > 0) {
				if (end < start)
					end = start + 1;
				q.setMaxResults(end - start);
			}

			List list = q.list();

			session.getTransaction().commit();

			logger.trace(String.format("denispyr return ModelerFulls %s", list));
			return list;
		} catch (Exception e) {
			logger.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static List getModelerFulls(String userId) throws Exception {
		Session session = null;

		try {
			logger.trace(String.format("denispyr start getModelerFulls"));
			session = HibernateUtil.openSession();
			logger.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_USERID).setParameter("userid", userId);

			List list = q.list();

			session.getTransaction().commit();

			logger.trace(String.format("denispyr return ModelerFulls %s", list));
			return list;
		} catch (Exception e) {
			logger.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static int getModelerFullCount(String userId) throws Exception {
		Session session = null;

		try {
			logger.trace(String.format("denispyr start getModelerFulls"));
			session = HibernateUtil.openSession();
			logger.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_USERID_COUNT).setParameter("userid", userId);

			Number count = (Number) q.uniqueResult();

			session.getTransaction().commit();

			logger.trace(String.format("denispyr return count %s", count));
			return count.intValue();
		} catch (Exception e) {
			logger.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	// private static final String _GET_ALL_ON_USERID = "SELECT
	// {ModelerFullView.*}
	// FROM ModelerFullView WHERE userid = :userid ORDER BY designation ASC";
	private static final String _GET_ALL_ON_USERID = "FROM gr.i2s.bluebridge.simul.model.ModelerFull s WHERE s.userId = :userid ORDER BY s.designation ASC";
	private static final String _GET_ALL_ON_USERID_COUNT = "SELECT count(*) FROM gr.i2s.bluebridge.simul.model.ModelerFull s WHERE s.userId = :userid";
	private static Log logger = LogFactoryUtil.getLog(ModelerFullUtil.class);
}
