package gr.i2s.bluebridge.simul.portlet;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.util.bridges.mvc.MVCPortlet;

import gr.i2s.bluebridge.simul.calc.ScenarioExecutor;
import gr.i2s.bluebridge.simul.model.ModelerFull;
import gr.i2s.bluebridge.simul.model.Scenario;
import gr.i2s.bluebridge.simul.model.util.ModelerFullUtil;
import gr.i2s.bluebridge.simul.model.util.ScenarioUtil;

/**
 * Portlet implementation class SimulPortlet
 */
public class SimulPortlet extends MVCPortlet {
	private static Log logger = LogFactoryUtil.getLog(SimulPortlet.class);

	@Override
	public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
		logger.info(String.format("render path [%s]", getPath(request)));

		String path = getPath(request);
		if (path == null || path.endsWith("view.jsp") || path.endsWith("startScenario.jsp")) {
			logger.trace("Preparing view");

			String userId = null; // invalid
			try {
				ServiceContext context = ServiceContextFactory.getInstance(request);
				userId = String.valueOf(context.getUserId());
			} catch (SystemException | PortalException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			request.setAttribute("userId", userId);

		} else if (path.endsWith("edit.jsp")) {
			logger.trace("Preparing edit");

			String userId = null; // invalid
			try {
				ServiceContext context = ServiceContextFactory.getInstance(request);
				userId = String.valueOf(context.getUserId());
			} catch (SystemException | PortalException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			List<ModelerFull> modelerList = null;

			try {
				modelerList = new ArrayList<>(
						ModelerFullUtil.getModelerFulls(userId, QueryUtil.ALL_POS, QueryUtil.ALL_POS));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			if (modelerList == null) {
				modelerList = new ArrayList<>();
			}
			request.setAttribute("modelerList", modelerList);

		} else {
			logger.trace("Preparing nothing!");

		}

		super.render(request, response);
	}

	public void save(ActionRequest request, ActionResponse response) throws Exception {
		logger.debug("saveScenario action");
		ServiceContext context = ServiceContextFactory.getInstance(request);

		Long id = ParamUtil.getLong(request, "id");
		Scenario scenario;
		if (id > 0) {
			scenario = ScenarioUtil.getScenario(id);
		} else {
			scenario = new Scenario();
		}
		String designation = ParamUtil.getString(request, "designation");
		String comments = ParamUtil.getString(request, "comments");
		Long modelerId = ParamUtil.getLong(request, "modelerId");
		String startDate = ParamUtil.getString(request, "startDateFrm");
		Integer fishNo = ParamUtil.getInteger(request, "fishNo");
		Double weight = ParamUtil.getDouble(request, "weight");
		String targetDate = ParamUtil.getString(request, "targetDateFrm");
		scenario.setDesignation(designation);
		scenario.setComments(comments);
		scenario.setModelerId(modelerId);
		scenario.setStartDateFrm(startDate);
		scenario.setFishNo(fishNo);
		scenario.setWeight(weight);
		scenario.setTargetDateFrm(targetDate);
		scenario.setUserId(String.valueOf(context.getUserId()));

		if (logger.isTraceEnabled()) {
			logger.trace(String.format("persisting %s", scenario));
		}

		if (id > 0) {
			ScenarioUtil.update(scenario);
		} else {
			ScenarioUtil.add(scenario);
		}

		logger.debug(String.format("Saved [%s]", scenario));

		final PortletSession psession = request.getPortletSession();
		psession.setAttribute("scenarioId", id, PortletSession.PORTLET_SCOPE);
		// psession.getAttribute(key, PortletSession.APPLICATION_SCOPE);

		Boolean doRun = ParamUtil.getBoolean(request, "doRun");
		if (doRun) {
			new ScenarioExecutor(scenario).run();
		}

		response.setRenderParameter("jspPage", "/html/simul/startScenario.jsp");
	}

	public void delete(ActionRequest request, ActionResponse response) throws Exception {
		long id = ParamUtil.getLong(request, "id");
		logger.debug(String.format("Deleting scenarioId [%s]", id));
		ScenarioUtil.delete(id);

	}

}
