/*
 * Decompiled with CFR 0.152.
 */
package gr.i2s.bluebridge.simul.calc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import gr.i2s.bluebridge.simul.calc.ScenarioExecutor;
import gr.i2s.bluebridge.simul.model.Fcr;
import gr.i2s.bluebridge.simul.model.ModelerFull;
import gr.i2s.bluebridge.simul.model.Mortality;
import gr.i2s.bluebridge.simul.model.Scenario;
import gr.i2s.bluebridge.simul.model.Sfr;
import gr.i2s.bluebridge.simul.model.Site;
import gr.i2s.bluebridge.simul.model.util.FcrUtil;
import gr.i2s.bluebridge.simul.model.util.ModelerFullUtil;
import gr.i2s.bluebridge.simul.model.util.MortalityUtil;
import gr.i2s.bluebridge.simul.model.util.ScenarioUtil;
import gr.i2s.bluebridge.simul.model.util.SfrUtil;
import gr.i2s.bluebridge.simul.model.util.SiteUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class ScenarioExecutor {
    private static final Log logger = LogFactoryUtil.getLog(ScenarioExecutor.class);
    private static final SimpleDateFormat FULL_DATE_FORMAT = new SimpleDateFormat("YYYYMMdd-Hms-S");
    Ordering<Fcr> fcrByTempWeight = new /* Unavailable Anonymous Inner Class!! */;
    Ordering<Sfr> sfrByTempWeight = new /* Unavailable Anonymous Inner Class!! */;
    Ordering<Mortality> mortalityByTempWeight = new /* Unavailable Anonymous Inner Class!! */;
    private final Scenario mScenario;
    private final Map<Integer, RangeMap<Double, Double>> fcrTable;
    private final Map<Integer, RangeMap<Double, Double>> sfrTable;
    private final Map<Integer, RangeMap<Double, Double>> mortalityTable;
    private final Map<Long, Integer> temperatureTable;
    private final Integer[] modelTemperature;
    private final Queue<Daily> dailyResults;

    public ScenarioExecutor(Scenario scenario) {
        this.mScenario = scenario;
        this.fcrTable = new HashMap();
        this.sfrTable = new HashMap();
        this.mortalityTable = new HashMap();
        this.temperatureTable = new HashMap();
        this.modelTemperature = new Integer[24];
        this.dailyResults = new LinkedList();
    }

    public void run() {
        this.beforeRun();
        this.doRun();
        this.afterRun();
    }

    private void beforeRun() {
        long start = System.currentTimeMillis();
        try {
            ModelerFull modeler = null;
            modeler = ModelerFullUtil.getModelerFull((long)this.mScenario.getModelerId());
            Site entity = SiteUtil.getSite((long)modeler.getSiteId());
            this.modelTemperature[0] = entity.getPeriodJanA();
            this.modelTemperature[1] = entity.getPeriodJanB();
            this.modelTemperature[2] = entity.getPeriodFebA();
            this.modelTemperature[3] = entity.getPeriodFebB();
            this.modelTemperature[4] = entity.getPeriodMarA();
            this.modelTemperature[5] = entity.getPeriodMarB();
            this.modelTemperature[6] = entity.getPeriodAprA();
            this.modelTemperature[7] = entity.getPeriodAprB();
            this.modelTemperature[8] = entity.getPeriodMayA();
            this.modelTemperature[9] = entity.getPeriodMayB();
            this.modelTemperature[10] = entity.getPeriodJunA();
            this.modelTemperature[11] = entity.getPeriodJunB();
            this.modelTemperature[12] = entity.getPeriodJulA();
            this.modelTemperature[13] = entity.getPeriodJulB();
            this.modelTemperature[14] = entity.getPeriodAugA();
            this.modelTemperature[15] = entity.getPeriodAugB();
            this.modelTemperature[16] = entity.getPeriodSepA();
            this.modelTemperature[17] = entity.getPeriodSepB();
            this.modelTemperature[18] = entity.getPeriodOctA();
            this.modelTemperature[19] = entity.getPeriodOctB();
            this.modelTemperature[20] = entity.getPeriodNovA();
            this.modelTemperature[21] = entity.getPeriodNovB();
            this.modelTemperature[22] = entity.getPeriodDecA();
            this.modelTemperature[23] = entity.getPeriodDecB();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(this.mScenario.getStartDate());
        startDate.set(10, 0);
        startDate.set(12, 0);
        startDate.set(13, 0);
        startDate.set(14, 0);
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(this.mScenario.getTargetDate());
        endDate.set(10, 0);
        endDate.set(12, 0);
        endDate.set(13, 0);
        endDate.set(14, 0);
        Calendar curDate = startDate;
        while (!curDate.after(endDate)) {
            int month = curDate.get(2) + 1;
            int dayMonth = curDate.get(5);
            int idx = 2 * month - (dayMonth >= 15 ? 0 : 1) - 1;
            this.temperatureTable.put(curDate.getTimeInMillis(), this.modelTemperature[idx]);
            curDate.add(5, 1);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("temperature table from db [%s]", this.temperatureTable));
        }
        List fcrs = new ArrayList();
        try {
            fcrs.addAll(FcrUtil.getFcrs((long)this.mScenario.getModelerId()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("fcr list from db [%s]", fcrs));
        }
        fcrs = this.fcrByTempWeight.sortedCopy(fcrs);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("fcr list from db sorted [%s]", fcrs));
        }
        double lastLimit = 0.0;
        double prevMab = Double.MAX_VALUE;
        int curTemp = -1;
        TreeRangeMap tempColumn = null;
        for (Fcr fcr : fcrs) {
            if (fcr.getTemperature() != curTemp) {
                if (tempColumn != null) {
                    if (lastLimit > 0.0) {
                        tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit)), (Object)0.0);
                    }
                    this.fcrTable.put(curTemp, tempColumn);
                }
                curTemp = fcr.getTemperature();
                tempColumn = TreeRangeMap.create();
                prevMab = Double.MAX_VALUE;
            }
            double mab = fcr.getFromWeight();
            double fcrValue = fcr.getValue() / 100.0;
            tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(mab), (Comparable)Double.valueOf(prevMab)), (Object)fcrValue);
            lastLimit = mab;
            prevMab = mab;
        }
        if (tempColumn != null) {
            if (lastLimit > 0.0) {
                tempColumn.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit)), (Object)0.0);
            }
            this.fcrTable.put(curTemp, tempColumn);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("fcr table [%s]", this.fcrTable));
        }
        List sfrs = new ArrayList();
        try {
            sfrs.addAll(SfrUtil.getSfrs((long)this.mScenario.getModelerId()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("sfr list from db [%s]", sfrs));
        }
        sfrs = this.sfrByTempWeight.sortedCopy(sfrs);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("sfr list from db sorted [%s]", sfrs));
        }
        double lastLimit2 = 0.0;
        double prevMab2 = Double.MAX_VALUE;
        int curTemp2 = -1;
        TreeRangeMap tempColumn2 = null;
        for (Sfr sfr : sfrs) {
            if (sfr.getTemperature() != curTemp2) {
                if (tempColumn2 != null) {
                    if (lastLimit2 > 0.0) {
                        tempColumn2.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit2)), (Object)0.0);
                    }
                    this.sfrTable.put(curTemp2, tempColumn2);
                }
                curTemp2 = sfr.getTemperature();
                tempColumn2 = TreeRangeMap.create();
                prevMab2 = Double.MAX_VALUE;
            }
            double mab = sfr.getFromWeight();
            double sfrValue = sfr.getValue() / 100.0;
            tempColumn2.put(Range.closedOpen((Comparable)Double.valueOf(mab), (Comparable)Double.valueOf(prevMab2)), (Object)sfrValue);
            lastLimit2 = mab;
            prevMab2 = mab;
        }
        if (tempColumn2 != null) {
            if (lastLimit2 > 0.0) {
                tempColumn2.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit2)), (Object)0.0);
            }
            this.sfrTable.put(curTemp2, tempColumn2);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("sfr table [%s]", this.sfrTable));
        }
        List mortalities = new ArrayList();
        try {
            mortalities.addAll(MortalityUtil.getMortalities((long)this.mScenario.getModelerId()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("mortality list from db [%s]", mortalities));
        }
        mortalities = this.mortalityByTempWeight.sortedCopy(mortalities);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("mortality list from db sorted [%s]", mortalities));
        }
        double lastLimit3 = 0.0;
        double prevMab3 = Double.MAX_VALUE;
        int curTemp3 = -1;
        TreeRangeMap tempColumn3 = null;
        for (Mortality mortality : mortalities) {
            if (mortality.getTemperature() != curTemp3) {
                if (tempColumn3 != null) {
                    if (lastLimit3 > 0.0) {
                        tempColumn3.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit3)), (Object)0.0);
                    }
                    this.mortalityTable.put(curTemp3, tempColumn3);
                }
                curTemp3 = mortality.getTemperature();
                tempColumn3 = TreeRangeMap.create();
                prevMab3 = Double.MAX_VALUE;
            }
            double mab = mortality.getFromWeight();
            double mortalityValue = mortality.getValue() / 100.0;
            tempColumn3.put(Range.closedOpen((Comparable)Double.valueOf(mab), (Comparable)Double.valueOf(prevMab3)), (Object)mortalityValue);
            lastLimit3 = mab;
            prevMab3 = mab;
        }
        if (tempColumn3 != null) {
            if (lastLimit3 > 0.0) {
                tempColumn3.put(Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(lastLimit3)), (Object)0.0);
            }
            this.mortalityTable.put(curTemp3, tempColumn3);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("mortality table [%s]", this.mortalityTable));
        }
        long duration = System.currentTimeMillis() - start;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("preparation took [%s] ms", duration));
        }
    }

    private void afterRun() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("updating [%s]", this.mScenario));
            }
            ScenarioUtil.update((Scenario)this.mScenario);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("logger", (Object)logger).add("mScenario", (Object)this.mScenario).add("fcrTable", (Object)this.fcrTable).add("sfrTable", (Object)this.sfrTable).add("mortalityTable", (Object)this.mortalityTable).add("temperatureTable", (Object)this.temperatureTable).add("modelTemperature", (Object)Arrays.deepToString(new Object[]{this.modelTemperature})).add("dailyResults", (Object)Arrays.deepToString(new Object[]{this.dailyResults})).toString();
    }

    private void doRun() {
        long start = System.currentTimeMillis();
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(this.mScenario.getStartDate());
        startDate.set(10, 0);
        startDate.set(12, 0);
        startDate.set(13, 0);
        startDate.set(14, 0);
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(this.mScenario.getTargetDate());
        endDate.set(10, 0);
        endDate.set(12, 0);
        endDate.set(13, 0);
        endDate.set(14, 0);
        double startBM = this.mScenario.getWeight() * (double)this.mScenario.getFishNo();
        double totalFood = 0.0;
        double totalDeadBM = 0.0;
        int totalDead = 0;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("temperatureTable %s", this.temperatureTable));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("sfrTable %s", this.sfrTable));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("fcrTable %s", this.fcrTable));
        }
        Daily curDay = new Daily(this);
        curDay.mab = this.mScenario.getWeight();
        curDay.fishcount = this.mScenario.getFishNo();
        Calendar curDate = startDate;
        while (!curDate.after(endDate)) {
            double dayBM;
            Double dBM;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("on day [%s] as millis [%s]", FULL_DATE_FORMAT.format(curDate.getTime()), curDate.getTimeInMillis()));
            }
            curDay.date.setTimeInMillis(curDate.getTimeInMillis());
            curDay.dead = 0;
            curDay.food = 0.0;
            curDay.growth = 0.0;
            Integer temperature = (Integer)this.temperatureTable.get(curDay.date.getTimeInMillis());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("temperature %s", temperature));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("sfr temperature [%s] selection %s", temperature, this.sfrTable.get(temperature)));
            }
            curDay.temperature = temperature;
            Double sfr = (Double)((RangeMap)this.sfrTable.get(temperature)).get((Comparable)curDay.mab);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("sfr on mab [%s] selection %s", curDay.mab, sfr));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("fcr temperature [%s] selection %s", temperature, this.fcrTable.get(temperature)));
            }
            curDay.sfr = sfr * 100.0;
            Double fcr = (Double)((RangeMap)this.fcrTable.get(temperature)).get((Comparable)curDay.mab);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("fcr on mab [%s] selection %s", curDay.mab, fcr));
            }
            curDay.fcr = fcr * 100.0;
            curDay.dead = (int)((Double)((RangeMap)this.mortalityTable.get(temperature)).get((Comparable)curDay.mab) * (double)curDay.fishcount.intValue());
            curDay.deadBM = (double)curDay.dead.intValue() * curDay.mab;
            totalDead += curDay.dead.intValue();
            totalDeadBM += curDay.deadBM.doubleValue();
            curDay.fishcount = curDay.fishcount - curDay.dead;
            curDay.food = curDay.mab * (double)curDay.fishcount.intValue() * sfr;
            totalFood += curDay.food.doubleValue();
            double foodPerFish = curDay.food / (double)curDay.fishcount.intValue();
            curDay.growth = fcr > 0.0 ? foodPerFish / (fcr * 100.0) : 0.0;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("adding daily [%s]", curDay));
            }
            curDay.fcrEcon = (dBM = Double.valueOf((dayBM = curDay.mab * (double)curDay.fishcount.intValue()) - startBM)) > 0.0 ? totalFood / dBM : 0.0;
            dBM = dBM - totalDeadBM;
            curDay.fcrBiol = dBM > 0.0 ? totalFood / dBM : 0.0;
            this.dailyResults.add(curDay);
            Daily prevDay = curDay;
            curDay = new Daily(this, prevDay);
            curDay.mab = curDay.mab + prevDay.growth;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("prevDay [%s] curDay [%s]", prevDay, curDay));
            }
            prevDay = null;
            curDate.add(5, 1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("final day [%s]", curDay));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("detailed daily results [%s]", this.dailyResults));
        }
        double finalBM = curDay.mab * (double)curDay.fishcount.intValue();
        this.mScenario.setResultsWeight(curDay.mab.doubleValue());
        Double dBMEcon = finalBM - startBM;
        this.mScenario.setResultsEconFCR(dBMEcon > 0.0 ? totalFood / dBMEcon : 0.0);
        Double dBMBiol = dBMEcon - totalDeadBM;
        this.mScenario.setResultsBiolFCR(dBMBiol > 0.0 ? totalFood / dBMBiol : 0.0);
        this.mScenario.setResultsMortality(100.0 * ((double)totalDead / (double)this.mScenario.getFishNo()));
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        String tableWeight = new String();
        String tableFCR = new String();
        String tableFood = new String();
        String recordWeight = "{c:[{v: '%s'}, {v: %.2f}]},";
        String recordFCR = "{c:[{v: '%s'}, {v: %.2f}, {v: %.2f}]},";
        String recordFood = "{c:[{v: '%s-%s'}, {v: %.2f}]},";
        int foodMonth = -1;
        int foodYear = -1;
        double foodCons = 0.0;
        for (Daily daily : this.dailyResults) {
            String day = dateFormat.format(daily.date.getTime());
            tableWeight = String.valueOf(tableWeight) + String.format(recordWeight, day, daily.mab);
            if (daily.fcrBiol > 0.0) {
                tableFCR = String.valueOf(tableFCR) + String.format(recordFCR, day, daily.fcrBiol, daily.fcrEcon);
            }
            if (foodMonth != daily.date.get(2) || foodYear != daily.date.get(1)) {
                if (foodCons > 0.0) {
                    tableFood = String.valueOf(tableFood) + String.format(recordFood, foodMonth + 1, foodYear, foodCons / 1000.0);
                }
                foodCons = 0.0;
                foodMonth = daily.date.get(2);
                foodYear = daily.date.get(1);
            }
            foodCons += curDay.food.doubleValue();
        }
        if (foodCons > 0.0) {
            tableFood = String.valueOf(tableFood) + String.format(recordFood, foodMonth + 1, foodYear, foodCons / 1000.0);
        }
        this.mScenario.setResultsGraphData(String.valueOf(tableWeight) + "gri2sbbridge" + tableFCR + "gri2sbbridge" + tableFood);
        long duration = System.currentTimeMillis() - start;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("actual run took [%s] ms", duration));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("results [%s]", this.mScenario));
        }
    }

    static /* synthetic */ SimpleDateFormat access$0() {
        return FULL_DATE_FORMAT;
    }
}

