<%@page import="gr.i2s.bluebridge.simul.model.util.ScenarioFullUtil"%>
<%@ include file="/html/commons/inc.jsp"%>
<%@page import="gr.i2s.bluebridge.simul.model.ScenarioFull"%>
<%@page import="javax.portlet.PortletSession"%>
<%@page import="com.liferay.portal.kernel.log.LogFactoryUtil"%>
<%@page import="com.liferay.portal.kernel.log.Log"%>
<%@page import="com.liferay.portal.kernel.util.ParamUtil"%>

<%
	Log logger = LogFactoryUtil
			.getLog("gr.i2s.bluebridge.simul.portlet.jsp." + this.getClass().getSimpleName());
%>

<%
	ScenarioFull entity = null;
	long id = ParamUtil.getLong(request, "scenarioId");
	if (logger.isTraceEnabled())
		logger.trace(String.format("my id is [%s]", id));
	if (id <= 0) {
		final PortletSession psession = renderRequest.getPortletSession();
		if (logger.isTraceEnabled())
			logger.trace(String.format("tried the session and found [%s]",
					psession.getAttribute("scenarioId", PortletSession.PORTLET_SCOPE)));
		Long sesid = (Long) psession.getAttribute("scenarioId", PortletSession.PORTLET_SCOPE);
		if (sesid != null) {
			id = sesid;
		}

		if (logger.isTraceEnabled())
			logger.trace(String.format("after the session my id is [%s]", id));
	}
	if (id > 0) {
		try {
			entity = ScenarioFullUtil.getScenarioFull(id);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	if (logger.isDebugEnabled())
		logger.debug(String.format("loaded [%s]", entity));

	String graphs[] = entity.getResultsGraphData().split("gri2sbbridge");
	String tableWeight = graphs[0];
	String tableFCR = graphs[1];
	String tableFood = graphs[2];
%>

<liferay-ui:header title="<%=entity.getDesignation()%>"></liferay-ui:header>
<liferay-ui:panel-container accordion="true" extended="true">
	<liferay-ui:panel title="Data" state="open">
		<div>
			Average Weight:
			<%=entity.getResultsWeight()%></div>
		<div>
			LTD Growth:
			<%=entity.getResultsGrowth()%></div>
		<div>
			LTD SGR:
			<%=entity.getResultsSGR()%></div>
		<div>
			LTD Biological FCR:
			<%=entity.getResultsBiolFCR()%></div>
		<div>
			LTD Economical FCR:
			<%=entity.getResultsEconFCR()%></div>
		<div>
			LTD Mortality %:
			<%=entity.getResultsMortality()%></div>
	</liferay-ui:panel>

	<liferay-ui:panel title="Weight Graph" state="close">
		<div id="weight-graph-div"></div>
	</liferay-ui:panel>

	<liferay-ui:panel title="FCR Graph" state="close">
		<div id="fcr-graph-div"></div>
	</liferay-ui:panel>

	<liferay-ui:panel title="Food Consumption Graph" state="close">
		<div id="food-cons-graph-div"></div>
	</liferay-ui:panel>
</liferay-ui:panel-container>

<portlet:renderURL var="cancel">
	<portlet:param name="mvcPath" value="/html/simul/view.jsp"></portlet:param>
</portlet:renderURL>
<portlet:renderURL var="edit">
	<portlet:param name="mvcPath" value="/html/simul/edit.jsp"></portlet:param>
	<portlet:param name="scenarioId"
		value="<%=String.valueOf(entity.getId())%>" />
</portlet:renderURL>
<aui:button-row cssClass="simul-button">
	<aui:button onClick="<%=cancel.toString()%>" value="My Scenarios"></aui:button>
	<aui:button onClick="<%=edit.toString()%>" value="Edit scenario"></aui:button>
</aui:button-row>
<script type="text/javascript">
google.charts.load("current", {packages:['corechart']})

// Set a callback to run when the Google Visualization API is loaded.
google.charts.setOnLoadCallback(drawWeightChart);
google.charts.setOnLoadCallback(drawFCRChart);
google.charts.setOnLoadCallback(drawFoodConsChart);

// Callback that creates and populates a data table,
// instantiates the pie chart, passes in the data and
// draws it.
function drawFoodConsChart() {

  // Create the data table.
	var data = new google.visualization.DataTable({
			cols: [{id: 'month', label: 'Month', type: 'string'},
		            {id: 'weight', label: 'kg', type: 'number'}],		
		            rows: [<%=tableFood%>]
	});

  // Set chart options
  var options = {
		  'title':'Monthly food consumption',
          'width':700,
          'height':500,
          'vAxis': {minValue: 0} };

  // Instantiate and draw our chart, passing in some options.
  var chart = new google.visualization.ColumnChart(document.getElementById('food-cons-graph-div'));
  chart.draw(data, options);
}

function drawWeightChart() {
	// Create the data table.
	var data = new google.visualization.DataTable({
			cols: [{id: 'day', label: 'Day', type: 'string'},
		            {id: 'weight', label: 'Weight', type: 'number'}],		
		            rows: [<%=tableWeight%>]
	});
	
	// Set chart options
	var options = {
		title: 'Weight',
		curveType: 'function',
		legend: { position: 'bottom' },
		'width':600,
		'height':600
	};
	
	
	// Instantiate and draw our chart, passing in some options.
	var chart = new google.visualization.LineChart(document.getElementById('weight-graph-div'));
	chart.draw(data, options);
}

function drawFCRChart() {
	// Create the data table.
	var data = new google.visualization.DataTable();
	data.addColumn('string', 'Day');
	data.addColumn('number', 'FCR');
	data.addColumn('number', 'Global FCR');

	var data = new google.visualization.DataTable({
		cols: [{id: 'day', label: 'Day', type: 'string'},
	            {id: 'fcr', label: 'FCR', type: 'number'},
	            {id: 'globalfcr', label: 'Global FCR', type: 'number'}],		
	            rows: [<%=tableFCR%>]
	});
	
	// Set chart options
	var options = {
		title: 'FCR (%)',
		legend: { position: 'top' },
		colors: ['green', 'red'],
		'width':800,
		'height':600
	};
	
	
	// Instantiate and draw our chart, passing in some options.
	var chart = new google.visualization.LineChart(document.getElementById('fcr-graph-div'));
	chart.draw(data, options);
}
</script>

