package gr.i2s.bluebridge.simul.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Scenario extends EntityWithUserId {
	public String comments;
	public long modelerId;
	public Date targetDate;
	public Date startDate;
	public int fishNo;
	public double weight;
	public double resultsWeight;
	public double resultsGrowth;
	public double resultsEconFCR;
	public double resultsBiolFCR;
	public double resultsSGR;
	public double resultsMortality;
	public String resultsGraphData;

	/**
	 * dummy in order to set/get formatted date
	 */
	public static final SimpleDateFormat PARSER_DATE = new SimpleDateFormat("dd/MM/yyyy");

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public long getModelerId() {
		return modelerId;
	}

	public void setModelerId(long modelerId) {
		this.modelerId = modelerId;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getTargetDate() {
		return targetDate;
	}

	public void setTargetDate(Date targetDate) {
		this.targetDate = targetDate;
	}

	public int getFishNo() {
		return fishNo;
	}

	public void setFishNo(int fishNo) {
		this.fishNo = fishNo;
	}

	public double getWeight() {
		return weight;
	}

	public void setWeight(double weight) {
		this.weight = weight;
	}

	public double getResultsWeight() {
		return resultsWeight;
	}

	public void setResultsWeight(double resultsWeight) {
		this.resultsWeight = resultsWeight;
	}

	public double getResultsGrowth() {
		return resultsGrowth;
	}

	public void setResultsGrowth(double resultsGrowth) {
		this.resultsGrowth = resultsGrowth;
	}

	public double getResultsEconFCR() {
		return resultsEconFCR;
	}

	public void setResultsEconFCR(double resultsEconFCR) {
		this.resultsEconFCR = resultsEconFCR;
	}

	public double getResultsBiolFCR() {
		return resultsBiolFCR;
	}

	public void setResultsBiolFCR(double resultsBiolFCR) {
		this.resultsBiolFCR = resultsBiolFCR;
	}

	public double getResultsSGR() {
		return resultsSGR;
	}

	public void setResultsSGR(double resultsSGR) {
		this.resultsSGR = resultsSGR;
	}

	public double getResultsMortality() {
		return resultsMortality;
	}

	public void setResultsMortality(double resultsMortality) {
		this.resultsMortality = resultsMortality;
	}

	public String getResultsGraphData() {
		return resultsGraphData;
	}

	public void setResultsGraphData(String resultsGraphData) {
		this.resultsGraphData = resultsGraphData;
	}

	/**
	 * dummy in order to set/get formatted date
	 * 
	 * @param startDate
	 */
	public void setStartDateFrm(String startDate) {
		try {
			setStartDate(PARSER_DATE.parse(startDate));
		} catch (ParseException e) {
			throw new RuntimeException(
					String.format("Bad date [%s] for pattern [%s]", startDate, PARSER_DATE.toPattern()), e);
		}
	}

	/**
	 * dummy in order to set/get formatted date
	 * 
	 */
	public String getStartDateFrm() {
		return PARSER_DATE.format(startDate);
	}

	/**
	 * dummy in order to set/get formatted date
	 * 
	 * @param targetDate
	 */
	public void setTargetDateFrm(String targetDate) {
		try {
			setStartDate(PARSER_DATE.parse(targetDate));
		} catch (ParseException e) {
			throw new RuntimeException(
					String.format("Bad date [%s] for pattern [%s]", targetDate, PARSER_DATE.toPattern()), e);
		}
	}

	/**
	 * dummy in order to set/get formatted date
	 * 
	 */
	public String getTargetDateFrm() {
		return PARSER_DATE.format(targetDate);
	}

	@Override
	public String toString() {
		return new StringBuilder().append("Scenario [").append(super.toString()).append("comments=").append(comments)
				.append(", modelerId=").append(modelerId).append(", targetDate=").append(targetDate)
				.append(", startDate=").append(startDate).append(", fishNo=").append(fishNo).append(", weight=")
				.append(weight).append(", resultsWeight=").append(resultsWeight).append(", resultsGrowth=")
				.append(resultsGrowth).append(", resultsEconFCR=").append(resultsEconFCR).append(", resultsBiolFCR=")
				.append(resultsBiolFCR).append(", resultsSGR=").append(resultsSGR).append(", resultsMortality=")
				.append(resultsMortality).append(", resultsGraphData=").append(resultsGraphData).append("]").toString();
	}

}
