package gr.i2s.bluebridge.simul.model.util;

import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gr.i2s.bluebridge.simul.util2.HibernateUtil;

public class FcrUtil {

	public static List getFcrs(long modelerId) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_MODELER).setParameter("modelerId", modelerId);

			List list = q.list();

			session.getTransaction().commit();

			return list;
		} catch (Exception e) {
			log.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static int deleteAll(long id, int idx) {
		Session session = null;

		int toRet = 0;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			Query q = session.createQuery(_DEL_ALL_ON_MODELER_INDEX).setParameter("modelerId", id).setParameter("index",
					idx);

			toRet = q.executeUpdate();

			session.getTransaction().commit();

		} catch (Exception e) {
			log.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}

		return toRet;
	}

	// private static final String _GET_ALL_ON_USERID = "SELECT {SiteView.*}
	// FROM SiteView WHERE userid = :userid ORDER BY designation ASC";
	private static final String _GET_ALL_ON_MODELER = "FROM gr.i2s.bluebridge.simul.model.Fcr s WHERE s.modelerId = :modelerId ORDER BY s.temperature ASC, fromWeight DESC";
	private static final String _DEL_ALL_ON_MODELER_INDEX = "DELETE FROM gr.i2s.bluebridge.simul.model.Fcr s WHERE s.modelerId = :modelerId AND s.index = :index";
	private static Log log = LogFactoryUtil.getLog(FcrUtil.class);
}
