package gr.i2s.bluebridge.simul.portlet;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Constants;
import com.liferay.portal.kernel.util.ParamUtil;

import gr.i2s.bluebridge.simul.model2.Foo;
import gr.i2s.bluebridge.simul.util2.FooUtil;

/**
 * Portlet implementation class FooPortlet
 */
public class FooPortlet extends GenericPortlet {

	@Override
	public void destroy() {
		if (_log.isInfoEnabled()) {
			_log.info("Destroying portlet");
		}
	}

	@Override
	public void doView(RenderRequest renderRequest, RenderResponse renderResponse)
			throws IOException, PortletException {

		PortletContext portletContext = getPortletContext();

		PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/html/foo/view.jsp");

		if (portletRequestDispatcher == null) {
			_log.error("/foo/view.jsp is not a valid include");
		} else {
			try {
				portletRequestDispatcher.include(renderRequest, renderResponse);
			} catch (Exception e) {
				_log.error(e, e);

				portletRequestDispatcher = portletContext.getRequestDispatcher("/html/error.jsp");

				if (portletRequestDispatcher == null) {
					_log.error("/html/error.jsp is not a valid include");
				} else {
					portletRequestDispatcher.include(renderRequest, renderResponse);
				}
			}
		}
	}

	@Override
	public void init(PortletConfig portletConfig) throws PortletException {
		super.init(portletConfig);

		if (_log.isInfoEnabled()) {
			_log.info("Initializing portlet");
		}
	}

	@Override
	public void processAction(ActionRequest actionRequest, ActionResponse actionResponse)
			throws IOException, PortletException {

		String cmd = ParamUtil.getString(actionRequest, Constants.CMD);

		long id = ParamUtil.getLong(actionRequest, "id");

		String name = actionRequest.getParameter("name");

		try {
			if (cmd.equals(Constants.ADD)) {
				Foo foo = new Foo();

				foo.setDesignation(name);

				FooUtil.addFoo(foo);
			} else if (cmd.equals(Constants.EDIT)) {
				Foo foo = FooUtil.getFoo(id);

				foo.setDesignation(name);

				FooUtil.updateFoo(foo);
			} else if (cmd.equals(Constants.DELETE)) {
				FooUtil.deleteFoo(id);
			}
		} catch (Exception e) {
			throw new PortletException(e);
		}
	}

	private static Log _log = LogFactoryUtil.getLog(FooPortlet.class);

}
