package gr.i2s.bluebridge.simul.portlet;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.bridges.mvc.MVCPortlet;

import gr.i2s.bluebridge.simul.model.BroodstockQuality;
import gr.i2s.bluebridge.simul.model.FeedQuality;
import gr.i2s.bluebridge.simul.model.Modeler;
import gr.i2s.bluebridge.simul.model.Site;
import gr.i2s.bluebridge.simul.model.Species;
import gr.i2s.bluebridge.simul.model.util.BroodstockQualityUtil;
import gr.i2s.bluebridge.simul.model.util.FeedQualityUtil;
import gr.i2s.bluebridge.simul.model.util.ModelerFullUtil;
import gr.i2s.bluebridge.simul.model.util.ModelerUtil;
import gr.i2s.bluebridge.simul.model.util.SiteFullUtil;
import gr.i2s.bluebridge.simul.model.util.SpeciesUtil;

/**
 * Portlet implementation class ModelerPortlet
 */
public class ModelerPortlet extends MVCPortlet {
	private static Log logger = LogFactoryUtil.getLog(ModelerPortlet.class);

	@Override
	public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
		logger.info(String.format("render path [%s]", getPath(request)));

		String path = getPath(request);
		if (path == null || path.endsWith("view.jsp")) {
			logger.trace("Preparing view");

			String userId = null; // invalid
			try {
				ServiceContext context = ServiceContextFactory.getInstance(request);
				userId = String.valueOf(context.getUserId());
			} catch (SystemException | PortalException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			request.setAttribute("userId", userId);

		} else if (path.endsWith("edit.jsp")) {
			logger.trace("Preparing edit");

			String userId = null; // invalid
			try {
				ServiceContext context = ServiceContextFactory.getInstance(request);
				userId = String.valueOf(context.getUserId());
			} catch (SystemException | PortalException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			List<Species> specieList = null;
			List<Site> siteList = null;
			List<BroodstockQuality> broodstockQualityList = null;
			List<FeedQuality> feedQualityList = null;

			try {
				specieList = new ArrayList<>(SpeciesUtil.getSpecieses());
				siteList = new ArrayList<>(SiteFullUtil.getSiteFulls(userId));
				// TODO denispyr delete me
				if (logger.isTraceEnabled()) {
					logger.trace(String.format("Site count %s full %s", siteList.size(),
							new ArrayList<>(SiteFullUtil.getSiteFulls(userId).size())

					));
				}
				broodstockQualityList = new ArrayList<>(BroodstockQualityUtil.getBroodstockQualities());
				feedQualityList = new ArrayList<>(FeedQualityUtil.getFeedQualities());
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			if (specieList == null) {
				specieList = new ArrayList<>();
			}
			request.setAttribute("specieList", specieList);

			if (siteList == null) {
				siteList = new ArrayList<>();
			}
			request.setAttribute("siteList", siteList);

			if (broodstockQualityList == null) {
				broodstockQualityList = new ArrayList<>();
			}
			request.setAttribute("broodstockQualityList", broodstockQualityList);

			if (feedQualityList == null) {
				feedQualityList = new ArrayList<>();
			}
			request.setAttribute("feedQualityList", feedQualityList);

		} else {
			logger.trace("Preparing nothing!");

		}

		super.render(request, response);
	}

	public void save(ActionRequest request, ActionResponse response) throws Exception {
		ServiceContext context = ServiceContextFactory.getInstance(request);

		Long id = ParamUtil.getLong(request, "id");
		Modeler modeler;
		if (id > 0) {
			modeler = ModelerUtil.getModeler(id);
		} else {
			modeler = new Modeler();
		}
		String designation = ParamUtil.getString(request, "designation");
		String comments = ParamUtil.getString(request, "comments");
		Long speciesId = ParamUtil.getLong(request, "speciesId");
		Long siteId = ParamUtil.getLong(request, "siteId");
		Long broodstockQualityId = ParamUtil.getLong(request, "broodstockQualityId");
		Boolean broodstockGeneticImprovement = ParamUtil.get(request, "broodstockGeneticImprovement", false);
		Long feedQualityId = ParamUtil.getLong(request, "feedQualityId");

		// manage uploaded files
		String[] filenames = new String[4];
		filenames[0] = modeler.getUploadFilename1();
		filenames[1] = modeler.getUploadFilename2();
		filenames[2] = modeler.getUploadFilename3();
		filenames[3] = modeler.getUploadFilename4();
		File[] files = new File[4];

		for (int i = 1; i <= 4; i++) {
			String action = ParamUtil.getString(request, String.format("fileUploadAction%s", i));

			if (action.equals("keep")) {
				// keep it that way
				if (logger.isDebugEnabled()) {
					logger.debug(String.format("for upload [%s] the action is [keep] so I do nothing", i));
				}
				continue;
			}

			if (action.equals("delete")) {
				if (logger.isDebugEnabled()) {
					logger.debug(String.format(
							"for upload [%s] the action is [delete] so I will delete the KPIs and clear the modeler fields",
							i));
				}
				filenames[i - 1] = "";
				files[i - 1] = null;
				ModelerUtil.cleanKPIs(id, i);
				continue;
			}

			// action is "replace"; either add new or replace existing
			if (logger.isDebugEnabled()) {
				logger.debug(String.format("for upload [%s] the action is [replace] so I will upload a file", i));
			}

			String fileInputName = String.format("fileUpload%s", i);

			UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest(request);

			long sizeInBytes = uploadRequest.getSize(fileInputName);

			// Get the uploaded file as a file.
			File uploadedFile = uploadRequest.getFile(fileInputName);

			String sourceFileName = uploadRequest.getFileName(fileInputName);

			if (uploadRequest.getSize(fileInputName) == 0) {
				logger.warn(String.format("Bypassing 0 bytes file: [%s]", sourceFileName));
				continue;
			}

			if (!Strings.isNullOrEmpty(filenames[i - 1])) {
				if (logger.isDebugEnabled()) {
					logger.debug(String.format("the user replaces the file for [%s] so I will clear the old KPIs", i));
				}
				ModelerUtil.cleanKPIs(id, i);
			}

			// Allocate temp space in orde to store
			File targetFile = File.createTempFile("gr_i2s_simul_",
					"." + Files.getFileExtension(uploadedFile.getName()));

			if (logger.isTraceEnabled()) {
				logger.trace(String.format("I will try to save as [%s]", targetFile.getAbsolutePath()));
			}

			// Check minimum 1GB storage space to save new files...

			if (targetFile.getUsableSpace() < sizeInBytes) {
				throw new Exception(String.format("Out of disk space! I have [%s] available while I need [%s]",
						targetFile.getUsableSpace(), sizeInBytes));
			}

			// Move the existing temporary file to new location.
			Files.copy(uploadedFile, targetFile);

			if (logger.isDebugEnabled()) {
				logger.debug(String.format("copied [%s] as [%s]", sourceFileName, targetFile));
			}

			filenames[i - 1] = sourceFileName;
			files[i - 1] = targetFile;
		}

		modeler.setDesignation(designation);
		modeler.setComments(comments);
		modeler.setSpeciesId(speciesId);
		modeler.setSiteId(siteId);
		modeler.setBroodstockQualityId(broodstockQualityId);
		modeler.setBroodstockGeneticImprovement(broodstockGeneticImprovement);
		modeler.setFeedQualityId(feedQualityId);
		modeler.setUserId(String.valueOf(context.getUserId()));
		// $#%@#$%@#$ I don't have a list, I have numbered members #$@$@#$%#@%
		modeler.setUploadFilename1(filenames[0]);
		modeler.setUploadFilename2(filenames[1]);
		modeler.setUploadFilename3(filenames[2]);
		modeler.setUploadFilename4(filenames[3]);

		if (logger.isTraceEnabled()) {
			logger.trace(String.format("persisting %s", modeler));
		}

		if (id > 0) {
			ModelerUtil.update(modeler);
		} else {
			ModelerUtil.add(modeler);
		}
	}

	public void delete(ActionRequest request, ActionResponse response) throws Exception {
		long id = ParamUtil.getLong(request, "id");
		logger.debug(String.format("Deleting modeler [%s]", id));
		ModelerFullUtil.delete(id);

	}

}
