/*
 * Decompiled with CFR 0.152.
 */
package gr.i2s.bluebridge.simul.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.util.bridges.mvc.MVCPortlet;
import gr.i2s.bluebridge.simul.calc.ScenarioExecutor;
import gr.i2s.bluebridge.simul.model.Scenario;
import gr.i2s.bluebridge.simul.model.util.ModelerFullUtil;
import gr.i2s.bluebridge.simul.model.util.ScenarioUtil;
import java.io.IOException;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class SimulPortlet
extends MVCPortlet {
    private static Log logger = LogFactoryUtil.getLog(SimulPortlet.class);

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        logger.info((Object)String.format("render path [%s]", this.getPath((PortletRequest)request)));
        String path = this.getPath((PortletRequest)request);
        if (path == null || path.endsWith("view.jsp") || path.endsWith("startScenario.jsp")) {
            logger.trace((Object)"Preparing view");
            String userId = null;
            try {
                ServiceContext context = ServiceContextFactory.getInstance((PortletRequest)request);
                userId = String.valueOf(context.getUserId());
            }
            catch (PortalException | SystemException e) {
                e.printStackTrace();
            }
            request.setAttribute("userId", (Object)userId);
        } else if (path.endsWith("edit.jsp")) {
            logger.trace((Object)"Preparing edit");
            String userId = null;
            try {
                ServiceContext context = ServiceContextFactory.getInstance((PortletRequest)request);
                userId = String.valueOf(context.getUserId());
            }
            catch (PortalException | SystemException e) {
                e.printStackTrace();
            }
            ArrayList modelerList = null;
            try {
                modelerList = new ArrayList(ModelerFullUtil.getModelerFulls((String)userId, (int)-1, (int)-1));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (modelerList == null) {
                modelerList = new ArrayList();
            }
            request.setAttribute("modelerList", modelerList);
        } else {
            logger.trace((Object)"Preparing nothing!");
        }
        super.render(request, response);
    }

    public void save(ActionRequest request, ActionResponse response) throws Exception {
        logger.debug((Object)"saveScenario action");
        ServiceContext context = ServiceContextFactory.getInstance((PortletRequest)request);
        Long id = ParamUtil.getLong((PortletRequest)request, (String)"id");
        Scenario scenario = id > 0L ? ScenarioUtil.getScenario((long)id) : new Scenario();
        String designation = ParamUtil.getString((PortletRequest)request, (String)"designation");
        String comments = ParamUtil.getString((PortletRequest)request, (String)"comments");
        Long modelerId = ParamUtil.getLong((PortletRequest)request, (String)"modelerId");
        String startDate = ParamUtil.getString((PortletRequest)request, (String)"startDateFrm");
        Integer fishNo = ParamUtil.getInteger((PortletRequest)request, (String)"fishNo");
        Double weight = ParamUtil.getDouble((PortletRequest)request, (String)"weight");
        String targetDate = ParamUtil.getString((PortletRequest)request, (String)"targetDateFrm");
        scenario.setDesignation(designation);
        scenario.setComments(comments);
        scenario.setModelerId(modelerId.longValue());
        scenario.setStartDateFrm(startDate);
        scenario.setFishNo(fishNo.intValue());
        scenario.setWeight(weight.doubleValue());
        scenario.setTargetDateFrm(targetDate);
        scenario.setUserId(String.valueOf(context.getUserId()));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("persisting %s", scenario));
        }
        if (id > 0L) {
            ScenarioUtil.update((Scenario)scenario);
        } else {
            ScenarioUtil.add((Scenario)scenario);
        }
        logger.debug((Object)String.format("Saved [%s]", scenario));
        PortletSession psession = request.getPortletSession();
        psession.setAttribute("scenarioId", (Object)id, 2);
        Boolean doRun = ParamUtil.getBoolean((PortletRequest)request, (String)"doRun");
        if (doRun.booleanValue()) {
            new ScenarioExecutor(scenario).run();
        }
        response.setRenderParameter("jspPage", "/html/simul/startScenario.jsp");
    }

    public void delete(ActionRequest request, ActionResponse response) throws Exception {
        long id = ParamUtil.getLong((PortletRequest)request, (String)"id");
        logger.debug((Object)String.format("Deleting scenarioId [%s]", id));
        ScenarioUtil.delete((long)id);
    }
}

