/*
 * Decompiled with CFR 0.152.
 */
package smallgears.api.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import lombok.NonNull;
import smallgears.api.Apikit;

public class ConfigurationBinder<C> {
    @NonNull
    private final ObjectMapper mapper;
    @NonNull
    private final Class<C> type;

    public ConfigurationBinder(Class<C> type) {
        this(new ObjectMapper(), type);
    }

    public C load(InputStream stream) {
        try {
            return (C)this.mapper.readValue(stream, this.type);
        }
        catch (Exception e) {
            throw Apikit.unchecked("cannot load configuration (see cause)", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(C cfg, File location) {
        try {
            FileOutputStream stream = new FileOutputStream(location);
            try {
                this.mapper.writeValue((OutputStream)stream, cfg);
            }
            finally {
                if (Collections.singletonList(stream).get(0) != null) {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            throw Apikit.unchecked("cannot save configuration (see cause)", e);
        }
    }

    @ConstructorProperties(value={"mapper", "type"})
    public ConfigurationBinder(@NonNull ObjectMapper mapper, @NonNull Class<C> type) {
        if (mapper == null) {
            throw new IllegalArgumentException("mapper is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.mapper = mapper;
        this.type = type;
    }

    @NonNull
    public ObjectMapper mapper() {
        return this.mapper;
    }
}

