/*
 * Decompiled with CFR 0.152.
 */
package smallgears.api.configuration;

import java.beans.ConstructorProperties;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smallgears.api.Apikit;

public class ConfigurationProvider {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationProvider.class);
    @NonNull
    private final String locationProperty;
    @NonNull
    private final String filename;

    public Path locate() throws IllegalStateException {
        Path dir = this.locate_directory();
        if (dir == null && !this.validFileAt((dir = Paths.get(System.getProperty("user.dir"), new String[0])).resolve(this.filename))) {
            dir = Paths.get(System.getProperty("user.home"), new String[0]);
        }
        return dir.resolve(this.filename);
    }

    public Optional<InputStream> provide(boolean mandatory) {
        Path location = this.locate();
        InputStream stream = null;
        try {
            if (Files.exists(location, new LinkOption[0])) {
                log.info("loading configuration @ {}", (Object)location);
                stream = new FileInputStream(location.toFile());
            } else {
                stream = ConfigurationProvider.class.getResourceAsStream("/" + this.filename);
                if (stream != null) {
                    log.info("taking configuration for {} from classpath", (Object)this.filename);
                } else if (mandatory) {
                    throw new AssertionError((Object)String.format("no configuration for %s found on file system or classpath", this.filename));
                }
            }
            return Optional.ofNullable(stream);
        }
        catch (Exception e) {
            throw Apikit.unchecked(String.format("cannot read the configuration for %s", this.filename), e);
        }
    }

    private Path locate_directory() {
        String location = System.getProperty(this.locationProperty);
        if (location != null) {
            return this.validDirectoryAt(location);
        }
        location = System.getenv(this.locationProperty);
        if (location != null) {
            return this.validDirectoryAt(location);
        }
        return null;
    }

    private Path validDirectoryAt(@NonNull String location) {
        if (location == null) {
            throw new IllegalArgumentException("location is null");
        }
        Path path = Paths.get(location, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0]) && Files.isReadable(path)) {
            return path;
        }
        throw new IllegalStateException(String.format("invalid configuration @ {}: not a readable directory", path));
    }

    private boolean validFileAt(Path path) {
        return Files.isReadable(path) && !Files.isDirectory(path, new LinkOption[0]);
    }

    @ConstructorProperties(value={"locationProperty", "filename"})
    public ConfigurationProvider(@NonNull String locationProperty, @NonNull String filename) {
        if (locationProperty == null) {
            throw new IllegalArgumentException("locationProperty is null");
        }
        if (filename == null) {
            throw new IllegalArgumentException("filename is null");
        }
        this.locationProperty = locationProperty;
        this.filename = filename;
    }
}

