/*
 * Decompiled with CFR 0.152.
 */
package smallgears.api.tabular.dsl;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import smallgears.api.tabular.Column;
import smallgears.api.tabular.Csv;
import smallgears.api.tabular.Row;
import smallgears.api.tabular.Table;

public class Dsl {

    public static interface SinkClause {
        public void to(OutputStream var1);

        default public void at(Path file) {
            if (Files.isDirectory(file, new LinkOption[0]) || Files.exists(file, new LinkOption[0]) && !Files.isWritable(file)) {
                throw new IllegalArgumentException(file + " is unwritable or a directory.");
            }
            OutputStream stream = Files.newOutputStream(file, new OpenOption[0]);
            try {
                this.to(stream);
            }
            finally {
                if (Collections.singletonList(stream).get(0) != null) {
                    stream.close();
                }
            }
        }
    }

    public static interface SourceClause {
        public Table in(InputStream var1);

        default public Table in(String data) {
            return this.in(new ByteArrayInputStream(data.getBytes()));
        }

        default public Table at(Path file) {
            if (!Files.isReadable(file) || Files.isDirectory(file, new LinkOption[0])) {
                throw new IllegalArgumentException(file + " is unreadable or a directory.");
            }
            return this.in(new FileInputStream(file.toFile()));
        }
    }

    public static interface RowClause {
        public RowClause row(String ... var1);

        public RowClause row(Iterable<String> var1);

        public Table end();
    }

    public static interface TableClause {
        public Table with(String[] var1, String[] ... var2);

        public SourceClause from(Csv var1);

        public TableClause cols(Column ... var1);

        public TableClause cols(String ... var1);

        public TableClause cols(Iterable<Column> var1);

        public TableClause cols(Collection<String> var1);

        public Table rows(Row ... var1);

        public Table rows(Iterable<Row> var1);

        public Table rows(Iterator<Row> var1);

        public Table rows(String[] ... var1);

        public RowClause row(String ... var1);

        public RowClause row(Iterable<String> var1);
    }

    @FunctionalInterface
    public static interface ValueClause {
        public NameClause is(String var1);
    }

    public static interface NameClause {
        public ValueClause col(String var1);

        public ValueClause col(Column var1);

        public NameClause col(Column var1, String var2);

        public NameClause col(String var1, String var2);

        public Row end();
    }
}

