/*
 * Decompiled with CFR 0.152.
 */
package smallgears.api.tabular.impl;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smallgears.api.tabular.Column;
import smallgears.api.tabular.Csv;
import smallgears.api.tabular.Row;
import smallgears.api.tabular.dsl.Tables;
import smallgears.api.tabular.impl.AbstractTable;

public class CsvTable
extends AbstractTable {
    private static final Logger log = LoggerFactory.getLogger(CsvTable.class);
    private final Csv csv;
    private final RowIterator iterator;

    public CsvTable(Csv csv, InputStream stream) {
        super(csv.columns());
        this.csv = csv;
        this.iterator = new RowIterator(stream);
    }

    @Override
    public Iterator<Row> iterator() {
        return this.iterator;
    }

    private class RowIterator
    implements Iterator<Row> {
        private final CSVReader reader;
        private String[] row;
        private Throwable error;
        private int count;

        public RowIterator(InputStream stream) {
            try {
                this.reader = new CSVReader((Reader)new InputStreamReader(stream, CsvTable.this.csv.encoding()), CsvTable.this.csv.delimiter(), CsvTable.this.csv.quote());
                if (CsvTable.this.csv.hasHeader()) {
                    this.parseHeader();
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid csv asset: cannot read stream", e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.row != null) {
                return true;
            }
            if (CsvTable.this.csv.rows() <= this.count) {
                this.close();
                return false;
            }
            try {
                this.row = this.reader.readNext();
                ++this.count;
            }
            catch (IOException e) {
                this.error = e;
            }
            return this.row != null;
        }

        @Override
        public Row next() {
            try {
                this.checkRow();
            }
            catch (RuntimeException e) {
                this.close();
            }
            Row result = this.buildRow();
            this.row = null;
            return result;
        }

        private void checkRow() {
            if (this.error != null) {
                throw new RuntimeException(this.error);
            }
            if (this.row == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
        }

        private Row buildRow() {
            int i;
            HashMap<String, String> data = new HashMap<String, String>();
            if (CsvTable.this.csv.columns().isEmpty()) {
                for (i = 0; i < this.row.length; ++i) {
                    CsvTable.this.csv.with(Tables.col("column-" + i));
                }
            }
            for (i = 0; i < CsvTable.this.csv.columns().size(); ++i) {
                if (i >= this.row.length) continue;
                data.put(((Column)CsvTable.this.columns.get(i)).name(), this.row[i]);
            }
            return new Row(data);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void close() {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                log.warn("could not close CSV stream", (Throwable)e);
            }
        }

        private void parseHeader() {
            String[] cols = this.reader.readNext();
            if (CsvTable.this.csv.columns().isEmpty()) {
                for (int i = 0; i < cols.length; ++i) {
                    if (cols[i] == null || cols[i].isEmpty()) {
                        cols[i] = "column-" + i;
                    }
                    CsvTable.this.csv.with(Tables.col(cols[i]));
                }
            }
        }
    }
}

