/*
 * Decompiled with CFR 0.152.
 */
package smallgears.api.tabular.operations;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import smallgears.api.tabular.Row;
import smallgears.api.tabular.Table;
import smallgears.api.tabular.operations.OperationDsl;
import smallgears.api.tabular.utils.TableUtils;

public class TableOperations {
    private static BiConsumer<Row, Row> joinfunction = (s, t) -> s.merge((Row)t);

    public static OperationDsl.IndexClause<Row> index(@NonNull Table table) {
        if (table == null) {
            throw new IllegalArgumentException("table is null");
        }
        class IndexClauseImpl
        implements OperationDsl.IndexClause<Row> {
            final /* synthetic */ Table val$table;

            IndexClauseImpl(Table table) {
                this.val$table = table;
            }

            @Override
            public Map<String, Row> using(@NonNull Iterable<String> cols) {
                if (cols == null) {
                    throw new IllegalArgumentException("cols is null");
                }
                Function<Row, String> key = r -> TableUtils.join(TableUtils.streamof(cols).map(r::get));
                BinaryOperator picklatestduplicate = (r1, r2) -> r2;
                return this.val$table.stream().filter(r -> !((String)key.apply((Row)r)).isEmpty()).collect(Collectors.toMap(key, Function.identity(), picklatestduplicate));
            }

            @Override
            public OperationDsl.IndexClause<String> over(final @NonNull String col) {
                if (col == null) {
                    throw new IllegalArgumentException("col is null");
                }
                return new OperationDsl.IndexClause<String>(){

                    @Override
                    public OperationDsl.IndexClause<String> over(String col2) {
                        return this.over(col2);
                    }

                    @Override
                    public Map<String, String> using(Iterable<String> cols) {
                        return this.using(cols).entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((Row)e.getValue()).get(col)));
                    }
                };
            }
        }
        return new IndexClauseImpl(table);
    }

    public static OperationDsl.GroupClause group(@NonNull Table table) {
        if (table == null) {
            throw new IllegalArgumentException("table is null");
        }
        return cols -> {
            Function<Row, String> key = r -> TableUtils.join(TableUtils.streamof(cols).map(r::get));
            return table.stream().filter(r -> !((String)key.apply((Row)r)).isEmpty()).collect(Collectors.groupingBy(key, Collectors.toList()));
        };
    }

    public static OperationDsl.ExistMapClause indexist(@NonNull Table table) {
        if (table == null) {
            throw new IllegalArgumentException("table is null");
        }
        return cols -> {
            Function<Row, String> key = r -> TableUtils.join(TableUtils.streamof(cols).map(r::get));
            BinaryOperator picklatestduplicate = (n1, n2) -> n1;
            return table.stream().filter(r -> !((String)key.apply((Row)r)).isEmpty()).collect(Collectors.toMap(key, $ -> null, picklatestduplicate));
        };
    }

    public static Match match(@NonNull String col) {
        if (col == null) {
            throw new IllegalArgumentException("col is null");
        }
        return new Match(col, col);
    }

    public static Match match(@NonNull String sourcecol, @NonNull String targetcol) {
        if (sourcecol == null) {
            throw new IllegalArgumentException("sourcecol is null");
        }
        if (targetcol == null) {
            throw new IllegalArgumentException("targetcol is null");
        }
        return new Match(sourcecol, targetcol);
    }

    public static OperationDsl.WithClause join(final @NonNull Table table) {
        if (table == null) {
            throw new IllegalArgumentException("table is null");
        }
        return target -> new OperationDsl.JoinClause(){
            BiConsumer function = TableOperations.access$000();
            Consumer fallback = __ -> {};

            @Override
            public OperationDsl.JoinClause using(@NonNull BiConsumer<Row, Row> function) {
                this.function = function;
                return this;
            }

            @Override
            public OperationDsl.JoinClause fallbackWith(@NonNull Consumer<Row> function) {
                this.fallback = function;
                return this;
            }

            @Override
            public void basedOn(@NonNull Iterable<Match> matches) {
                List<String> targetcols = TableUtils.streamof(matches).map(Match::col2).collect(Collectors.toList());
                Map<String, Row> targetIndex = TableOperations.index(target).using(targetcols);
                table.forEach(row -> {
                    List sourcecols = TableUtils.streamof(matches).map(Match::col1).collect(Collectors.toList());
                    String key = TableUtils.join(TableUtils.streamof(sourcecols).map(row::get));
                    if (targetIndex.containsKey(key)) {
                        this.function.accept(row, targetIndex.get(key));
                    } else {
                        this.fallback.accept(row);
                    }
                });
                if (this.function == joinfunction) {
                    target.columns().stream().filter(c -> !table.columns().contains(c) || !targetcols.contains(c.name())).forEach(table.columns()::add);
                }
            }

            @Override
            public void basedOn(Match ... matches) {
                this.basedOn(Arrays.asList(matches));
            }
        };
    }

    public static class Match {
        String col1;
        String col2;

        @ConstructorProperties(value={"col1", "col2"})
        public Match(String col1, String col2) {
            this.col1 = col1;
            this.col2 = col2;
        }

        public String col1() {
            return this.col1;
        }

        public String col2() {
            return this.col2;
        }
    }
}

