/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import smallgears.api.properties.Properties;
import smallgears.api.properties.Property;
import smallgears.virtualrepository.AssetType;
import smallgears.virtualrepository.Repository;

public class Asset {
    @NonNull
    private AssetType type;
    @NonNull
    private String id;
    @NonNull
    private String name;
    private Repository repository;
    private Properties properties = Properties.props((Property[])new Property[0]);

    public Asset(AssetType type, String id, String name, @NonNull Repository repo) {
        this(type, id, name);
        if (repo == null) {
            throw new IllegalArgumentException("repo is null");
        }
        this.repository(repo);
    }

    public Asset(AssetType type, String name, Repository repo) {
        this(type, "unassigned", name, repo);
    }

    @ConstructorProperties(value={"type", "id", "name"})
    public Asset(@NonNull AssetType type, @NonNull String id, @NonNull String name) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.type = type;
        this.id = id;
        this.name = name;
    }

    @NonNull
    public AssetType type() {
        return this.type;
    }

    @NonNull
    public String id() {
        return this.id;
    }

    @NonNull
    public String name() {
        return this.name;
    }

    public Repository repository() {
        return this.repository;
    }

    public Properties properties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Asset)) {
            return false;
        }
        Asset other = (Asset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AssetType this$type = this.type();
        AssetType other$type = other.type();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Repository this$repository = this.repository();
        Repository other$repository = other.repository();
        if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
            return false;
        }
        Properties this$properties = this.properties();
        Properties other$properties = other.properties();
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Asset;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AssetType $type = this.type();
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        String $id = this.id();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        String $name = this.name();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        Repository $repository = this.repository();
        result = result * 59 + ($repository == null ? 0 : $repository.hashCode());
        Properties $properties = this.properties();
        result = result * 59 + ($properties == null ? 0 : $properties.hashCode());
        return result;
    }

    public String toString() {
        return "Asset(type=" + this.type() + ", id=" + this.id() + ", name=" + this.name() + ", repository=" + this.repository() + ", properties=" + this.properties() + ")";
    }

    public Asset repository(Repository repository) {
        this.repository = repository;
        return this;
    }
}

