/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;

public interface AssetType {
    public static final AssetType any = AssetType.of("any");

    public String name();

    default public Collection<AssetType> specialises() {
        return Collections.emptyList();
    }

    public static Simple of(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return new Simple(name);
    }

    public static class Simple
    implements AssetType {
        @NonNull
        private final String name;
        private final Set<AssetType> supertypes = new HashSet<AssetType>();

        public String toString() {
            return this.name;
        }

        public Simple specialises(AssetType ... types) {
            return this.specialises(Arrays.asList(types));
        }

        public Simple specialises(Iterable<AssetType> types) {
            types.forEach(this.supertypes::add);
            return this;
        }

        public Set<AssetType> specialises() {
            return this.supertypes;
        }

        @ConstructorProperties(value={"name"})
        public Simple(@NonNull String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Simple)) {
                return false;
            }
            Simple other = (Simple)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.name();
            String other$name = other.name();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Set<AssetType> this$supertypes = this.supertypes;
            Set<AssetType> other$supertypes = other.supertypes;
            return !(this$supertypes == null ? other$supertypes != null : !((Object)this$supertypes).equals(other$supertypes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Simple;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name();
            result = result * 59 + ($name == null ? 0 : $name.hashCode());
            Set<AssetType> $supertypes = this.supertypes;
            result = result * 59 + ($supertypes == null ? 0 : ((Object)$supertypes).hashCode());
            return result;
        }

        @Override
        @NonNull
        public String name() {
            return this.name;
        }
    }
}

