/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import smallgears.api.traits.Streamable;
import smallgears.virtualrepository.Asset;
import smallgears.virtualrepository.AssetType;
import smallgears.virtualrepository.Repositories;
import smallgears.virtualrepository.Repository;
import smallgears.virtualrepository.VR;
import smallgears.virtualrepository.impl.Extensions;
import smallgears.virtualrepository.impl.Transforms;

public interface VirtualRepository
extends Streamable<Asset> {
    public Repositories repositories();

    public Extensions extensions();

    public Transforms transforms();

    public int size();

    public Optional<Asset> lookup(String var1);

    public List<Asset> lookup(AssetType var1);

    public Map<AssetType, List<Asset>> lookup(AssetType ... var1);

    public DiscoverClause discover(Collection<AssetType> var1);

    default public DiscoverClause discover(AssetType ... types) {
        return this.discover(Arrays.asList(types));
    }

    public ContentCheckClause canRetrieve(Asset var1);

    public RetrieveAsClause retrieve(Asset var1);

    default public RetrieveAsClause retrieve(String id) {
        Asset asset = this.lookup(id).orElseThrow(() -> new IllegalStateException(String.format("unknown asset with id %s", id)));
        return this.retrieve(asset);
    }

    public ContentCheckClause canPublish(Asset var1);

    public PublishWithClause publish(Asset var1);

    public void shutdown();

    public static interface PublicationObserver {
        default public void onSuccess() {
        }

        default public void onError(Throwable t) {
        }
    }

    public static interface RetrievalObserver<A> {
        default public void onSuccess(A event) {
        }

        default public void onError(Throwable t) {
        }
    }

    public static interface DiscoveryObserver {
        default public void onNext(Asset event) {
        }

        default public void onCompleted() {
        }
    }

    public static interface PublishModeClause {
        public PublishModeClause timeout(Duration var1);

        public void blocking();

        public Future<?> withoutBlocking();

        public void notifying(PublicationObserver var1);
    }

    public static interface PublishWithClause {
        public PublishModeClause with(Object var1);
    }

    public static interface RetrieveModeClause<A> {
        public RetrieveModeClause<A> timeout(Duration var1);

        public A blocking();

        public Future<A> withoutBlocking();

        public void notifying(RetrievalObserver<A> var1);
    }

    public static interface RetrieveAsClause {
        public <A> RetrieveModeClause<A> as(Class<A> var1);
    }

    public static interface ContentCheckClause {
        public boolean as(Class<?> var1);
    }

    public static interface DiscoverClause {
        public DiscoverClause timeout(Duration var1);

        public DiscoverClause over(Repositories var1);

        default public DiscoverClause over(Repository ... repositories) {
            return this.over(VR.repositories(repositories));
        }

        public int blocking();

        public Future<Integer> withoutBlocking();

        public void notifying(DiscoveryObserver var1);
    }
}

