/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository.spi;

import lombok.NonNull;
import smallgears.virtualrepository.Asset;
import smallgears.virtualrepository.AssetType;
import smallgears.virtualrepository.spi.Transform;
import smallgears.virtualrepository.spi.VirtualReader;

public class ReaderAdapter<A1, A2>
implements VirtualReader<A2> {
    @NonNull
    private final VirtualReader<A1> reader;
    @NonNull
    private final Transform<A1, A2> transform;

    @Override
    public AssetType type() {
        return this.reader.type();
    }

    @Override
    public Class<A2> api() {
        return this.transform.targetApi();
    }

    @Override
    public A2 retrieve(Asset asset) throws Exception {
        return this.transform.apply(asset, this.reader.retrieve(asset));
    }

    private ReaderAdapter(@NonNull VirtualReader<A1> reader, @NonNull Transform<A1, A2> transform) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        if (transform == null) {
            throw new IllegalArgumentException("transform is null");
        }
        this.reader = reader;
        this.transform = transform;
    }

    public static <A1, A2> ReaderAdapter<A1, A2> adapt(@NonNull VirtualReader<A1> reader, @NonNull Transform<A1, A2> transform) {
        return new ReaderAdapter<A1, A2>(reader, transform);
    }
}

