package org.acme;

import java.util.Map;

import org.gcube.vremanagement.executor.persistence.Persistence;
import org.gcube.vremanagement.executor.persistence.PersistenceConnector;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class HelloWorldPlugin extends Plugin<HelloWorldPluginDeclaration> {

	/**
	 * Logger
	 */
	private static Logger logger = LoggerFactory.getLogger(HelloWorldPlugin.class);
	
	/**
	 * @param runningPluginEvolution
	 */
	public HelloWorldPlugin(HelloWorldPluginDeclaration pluginDeclaration, Persistence<? extends PersistenceConnector> persistence) {
		super(pluginDeclaration, persistence);
		logger.debug("contructor");
	}
	
	/**{@inheritDoc}*/
	@Override
	public void launch(Map<String, Object> inputs) throws Exception {
		logger.debug("Launching HelloWorld");
		if(inputs == null || inputs.isEmpty()){
			logger.debug(String.format("HelloWorld inputs %s", inputs));
			throw new Exception();
		}
				
		Thread.sleep(10000);
		logger.debug("HelloWorld finished");
	}

	/**{@inheritDoc}*/
	@Override
	protected void onStop() throws Exception {
		logger.debug("onStop()");
	}

}
