/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.api.types;

import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gcube.vremanagement.executor.api.types.Scheduling;
import org.gcube.vremanagement.executor.api.types.adapter.MapAdapter;
import org.gcube.vremanagement.executor.utils.MapCompare;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LaunchParameter
implements Comparable<LaunchParameter> {
    @XmlElement
    protected String pluginName;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    protected Map<String, String> pluginCapabilities;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    protected Map<String, Object> inputs;
    @XmlElement
    protected Scheduling scheduling;
    @XmlElement
    protected boolean persist;

    protected LaunchParameter() {
    }

    public LaunchParameter(String pluginName, Map<String, Object> inputs) {
        this(pluginName, null, inputs, null, false);
    }

    public LaunchParameter(String pluginName, Map<String, String> pluginCapabilities, Map<String, Object> inputs) {
        this(pluginName, pluginCapabilities, inputs, null, false);
    }

    public LaunchParameter(String pluginName, Map<String, Object> inputs, Scheduling scheduling) {
        this(pluginName, null, inputs, scheduling, false);
    }

    public LaunchParameter(String pluginName, Map<String, String> pluginCapabilities, Map<String, Object> inputs, Scheduling scheduling) {
        this(pluginName, pluginCapabilities, inputs, scheduling, false);
    }

    public LaunchParameter(String pluginName, Map<String, Object> inputs, Scheduling scheduling, boolean persist) {
        this(pluginName, null, inputs, scheduling, persist);
    }

    public LaunchParameter(String pluginName, Map<String, String> pluginCapabilities, Map<String, Object> inputs, Scheduling scheduling, boolean persist) {
        this.pluginName = pluginName;
        this.pluginCapabilities = pluginCapabilities;
        this.inputs = inputs;
        this.scheduling = scheduling;
        this.persist = persist;
    }

    @Deprecated
    public String getName() {
        return this.getPluginName();
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public Map<String, String> getPluginCapabilities() {
        return this.pluginCapabilities;
    }

    public void setPluginCapabilities(Map<String, String> pluginCapabilities) {
        this.pluginCapabilities = pluginCapabilities;
    }

    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    public Scheduling getScheduling() {
        return this.scheduling;
    }

    public void setScheduling(Scheduling scheduling) {
        this.scheduling = scheduling;
    }

    public String toString() {
        return String.format("%s : { Plugin : { Name: %s , Capabilites : %s}, Persist : %b, Scheduling : {%s}, Inputs : %s}", this.getClass().getSimpleName(), this.pluginName, this.pluginCapabilities, this.persist, this.scheduling, this.inputs);
    }

    public boolean isPersist() {
        return this.persist;
    }

    public void setPersist(boolean persist) {
        this.persist = persist;
    }

    @Override
    public int compareTo(LaunchParameter launchParameter) {
        int compareResult = 0;
        compareResult = new Boolean(this.persist).compareTo(new Boolean(launchParameter.persist));
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = this.pluginName.compareTo(launchParameter.pluginName);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = this.scheduling.compareTo(launchParameter.scheduling);
        if (compareResult != 0) {
            return compareResult;
        }
        MapCompare mapCompare = new MapCompare();
        return mapCompare.compareMaps(this.inputs, launchParameter.inputs);
    }
}

