/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.api.types;

import java.util.Calendar;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.quartz.CronExpression;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Scheduling
implements Comparable<Scheduling> {
    @XmlElement
    protected String cronExpression;
    @XmlElement
    protected Integer delay;
    @XmlElement
    protected int schedulingTimes;
    @XmlElement
    protected Long firstStartTime;
    @XmlElement
    protected Long endTime;
    @XmlElement
    protected boolean previuosExecutionsMustBeCompleted;

    protected void init(CronExpression cronExpression, Integer delay, int schedulingTimes, Long firstStartTime, Long endTime, boolean previuosExecutionsMustBeCompleted) {
        this.cronExpression = cronExpression != null ? cronExpression.getCronExpression() : null;
        this.delay = delay;
        this.schedulingTimes = schedulingTimes;
        this.firstStartTime = firstStartTime;
        this.endTime = endTime;
        this.previuosExecutionsMustBeCompleted = previuosExecutionsMustBeCompleted;
    }

    protected Scheduling() {
    }

    public Scheduling(CronExpression cronExpression) {
        this.init(cronExpression, null, 0, null, null, false);
    }

    public Scheduling(CronExpression cronExpression, boolean previuosExecutionsMustBeCompleted) {
        this.init(cronExpression, null, 0, null, null, previuosExecutionsMustBeCompleted);
    }

    public Scheduling(CronExpression cronExpression, int schedulingTimes) {
        this.init(cronExpression, null, schedulingTimes, null, null, false);
    }

    public Scheduling(CronExpression cronExpression, int schedulingTimes, boolean previuosExecutionsMustBeCompleted) {
        this.init(cronExpression, null, schedulingTimes, null, null, previuosExecutionsMustBeCompleted);
    }

    public Scheduling(CronExpression cronExpression, int schedulingTimes, Calendar firstStartTime, Calendar endTime) {
        this.init(cronExpression, null, schedulingTimes, firstStartTime.getTimeInMillis(), endTime.getTimeInMillis(), false);
    }

    public Scheduling(CronExpression cronExpression, int schedulingTimes, Calendar firstStartTime, Calendar endTime, boolean previuosExecutionsMustBeCompleted) {
        this.init(cronExpression, null, schedulingTimes, firstStartTime.getTimeInMillis(), endTime.getTimeInMillis(), previuosExecutionsMustBeCompleted);
    }

    public Scheduling(int delay) {
        this.init(null, delay, 0, null, null, false);
    }

    public Scheduling(int delay, boolean previuosExecutionsMustBeCompleted) {
        this.init(null, delay, 0, null, null, previuosExecutionsMustBeCompleted);
    }

    public Scheduling(int delay, int schedulingTimes) {
        this.init(null, delay, schedulingTimes, null, null, false);
    }

    public Scheduling(int delay, int schedulingTimes, boolean previuosExecutionsMustBeCompleted) {
        this.init(null, delay, schedulingTimes, null, null, previuosExecutionsMustBeCompleted);
    }

    public Scheduling(int delay, int schedulingTimes, Calendar firstStartTime, Calendar endTime) {
        this.init(null, delay, schedulingTimes, firstStartTime.getTimeInMillis(), endTime.getTimeInMillis(), false);
    }

    public Scheduling(int delay, int schedulingTimes, Calendar firstStartTime, Calendar endTime, boolean previuosExecutionsMustBeCompleted) {
        this.init(null, delay, schedulingTimes, firstStartTime.getTimeInMillis(), endTime.getTimeInMillis(), previuosExecutionsMustBeCompleted);
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public int getSchedulingTimes() {
        return this.schedulingTimes;
    }

    public boolean mustPreviousExecutionsCompleted() {
        return this.previuosExecutionsMustBeCompleted;
    }

    public Long getFirtStartTime() {
        return this.firstStartTime;
    }

    public Long getFirstStartTime() {
        return this.firstStartTime;
    }

    public void setFirstStartTime(Long firstStartTime) {
        this.firstStartTime = firstStartTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public String toString() {
        return String.format("CronExpression %s, Delay %d, SchedulingTimes %d, FirstStartTime %d, EndTime %d, PreviuosExecutionsMustBeCompleted %b", this.cronExpression, this.delay, this.schedulingTimes, this.firstStartTime, this.endTime, this.previuosExecutionsMustBeCompleted);
    }

    @Override
    public int compareTo(Scheduling scheduling) {
        int compareResult = 0;
        compareResult = this.cronExpression.compareTo(scheduling.cronExpression);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = this.delay.compareTo(scheduling.delay);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new Integer(this.schedulingTimes).compareTo(new Integer(scheduling.schedulingTimes));
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = this.firstStartTime.compareTo(scheduling.firstStartTime);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = this.endTime.compareTo(scheduling.endTime);
        if (compareResult != 0) {
            return compareResult;
        }
        return new Boolean(this.previuosExecutionsMustBeCompleted).compareTo(new Boolean(scheduling.previuosExecutionsMustBeCompleted));
    }
}

