/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.action.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.cotrix.action.Action;
import org.cotrix.action.ResourceType;
import org.cotrix.common.Utils;

public final class DefaultAction
implements Action {
    private final List<String> labels = new ArrayList<String>();
    private final ResourceType type;
    private final String resource;

    public DefaultAction(List<String> labels) {
        this(labels, ResourceType.none);
    }

    public DefaultAction(List<String> parts, ResourceType type) {
        this(parts, type, "*");
    }

    private DefaultAction(List<String> parts, ResourceType type, String resource) {
        Utils.valid((String)"labels", parts);
        Utils.notNull((String)"type", (Object)type);
        Utils.valid((String)"resource identifier", (String)resource);
        this.labels.addAll(parts);
        this.type = type;
        this.resource = resource;
    }

    @Override
    public Action on(String instance) {
        return new DefaultAction(this.labels, this.type, instance);
    }

    @Override
    public ResourceType type() {
        return this.type;
    }

    @Override
    public List<String> labels() {
        return this.labels;
    }

    @Override
    public boolean isTemplate() {
        return this.resource == "*";
    }

    @Override
    public String resource() {
        return this.resource;
    }

    @Override
    public boolean included(Action ... actions) {
        return this.included(Arrays.asList(actions));
    }

    @Override
    public boolean included(Collection<? extends Action> actions) {
        for (Action action : actions) {
            if (!this.isIn(action)) continue;
            return true;
        }
        return false;
    }

    public boolean isIn(Action a) {
        return this.type() == a.type() && this.matches(a.labels()) && this.match(this.resource, a.resource());
    }

    private boolean matches(List<String> parts) {
        for (int i = 0; i < parts.size(); ++i) {
            String part = parts.get(i);
            if (!(i >= this.labels().size() ? part != "*" : !this.match(this.labels().get(i), part))) continue;
            return false;
        }
        return true;
    }

    private boolean match(String s1, String s2) {
        return s1.equals(s2) || "*".equals(s2);
    }

    public String toString() {
        int maxLen = 100;
        String ps = this.labels.subList(0, Math.min(this.labels.size(), 100)).toString();
        return ps + " on " + this.resource;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.labels == null ? 0 : this.labels.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultAction other = (DefaultAction)obj;
        if (this.labels == null ? other.labels != null : !this.labels.equals(other.labels)) {
            return false;
        }
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

