/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.impl.news;

import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.cotrix.action.events.CodelistActionEvents;
import org.cotrix.application.NewsService;

public class CodelistActionReporter {
    @Inject
    private Event<NewsService.NewsItem> news;

    public void onImport(@Observes CodelistActionEvents.Import e) throws Exception {
        this.news.fire((Object)new NewsService.NewsItem(e.name + " version " + e.version + " now available."));
    }

    public void onVersion(@Observes CodelistActionEvents.Version e) throws Exception {
        this.news.fire((Object)new NewsService.NewsItem("version " + e.version + " of " + e.name + " now available."));
    }

    public void onPublish(@Observes CodelistActionEvents.Publish e) throws Exception {
        this.news.fire((Object)new NewsService.NewsItem(e.name + " version " + e.version + " has just been published to " + e.repository + "."));
    }

    public void onCreate(@Observes CodelistActionEvents.Create e) throws Exception {
        this.news.fire((Object)new NewsService.NewsItem("Version " + e.version + " of " + e.name + " has been created."));
    }
}

