/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import org.cotrix.application.ValidationService;
import org.cotrix.application.validation.ValidationItem;
import org.cotrix.common.Report;
import org.cotrix.common.Utils;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelink;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.dsl.Codes;

@Singleton
public class DefaultValidationService
implements ValidationService {
    private static String codeLinkError = "%s (%s): '%s' occurrences violate constraint %s";

    @Override
    public Report validate(Codelist list) {
        Utils.notNull((String)"codelist", (Object)list);
        return this.validateCodes(list, (Iterable<? extends Code>)list.codes());
    }

    @Override
    public Report validate(Codelist codelist, Collection<Code> codes) {
        Utils.notNull((String)"codelist", (Object)codelist);
        Utils.notEmpty((String)"codes", codes);
        return this.validateCodes(codelist, codes);
    }

    @Override
    public Report validate(Codelist codelist, Code ... codes) {
        Utils.notNull((String)"codelist", (Object)codelist);
        Utils.notEmpty((String)"codes", (Object[])codes);
        return this.validateCodes(codelist, Arrays.asList(codes));
    }

    private Report validateCodes(Codelist codelist, Iterable<? extends Code> codes) {
        Report report = new Report();
        this.validateLinks(codelist, codes, report);
        return report;
    }

    private void validateLinks(Codelist codelist, Iterable<? extends Code> codes, Report report) {
        Codelist.Private list = Codes.reveal((Codelist)codelist);
        HashMap<String, CodelistLink> links = new HashMap<String, CodelistLink>();
        for (CodelistLink codelistLink : list.links()) {
            links.put(codelistLink.id(), codelistLink);
        }
        for (Code code : codes) {
            this.validateLinks(Codes.reveal((Code)code), links, report);
        }
    }

    private void validateLinks(Code.Private code, Map<String, CodelistLink> linktypes, Report report) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (Codelink link : code.links()) {
            CodelistLink type = linktypes.get(link.type().id());
            if (type == null) continue;
            Integer count = (Integer)counts.get(type);
            counts.put(type.id(), count == null ? 1 : count + 1);
        }
        for (CodelistLink type : linktypes.values()) {
            int count;
            int n = count = counts.containsKey(type.id()) ? (Integer)counts.get(type.id()) : 0;
            if (type.range().inRange(count)) continue;
            report.log((Report.Item)ValidationItem.item(code.id(), String.format(codeLinkError, code.name(), code.id(), type.name(), type.range()))).as(Report.Item.Type.ERROR);
        }
    }
}

