/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.impl.mail;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.Template;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.Version;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.cotrix.application.MailService;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.cotrix.repository.Query;
import org.cotrix.repository.UserQueries;
import org.cotrix.repository.UserRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMailer {
    @Inject
    protected MailService mailService;
    @Inject
    protected UserRepository userRepository;
    protected static Configuration templateEngineConfiguration;
    private static final Logger log;

    protected static synchronized Configuration getEngineConfiguration() {
        if (templateEngineConfiguration == null) {
            templateEngineConfiguration = new Configuration();
            templateEngineConfiguration.setClassForTemplateLoading(AbstractMailer.class, "/templates");
            templateEngineConfiguration.setIncompatibleImprovements(new Version(2, 3, 20));
            templateEngineConfiguration.setDefaultEncoding("UTF-8");
            templateEngineConfiguration.setLocale(Locale.US);
            templateEngineConfiguration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            templateEngineConfiguration.setObjectWrapper((ObjectWrapper)new ObjectWrapperExtension());
        }
        return templateEngineConfiguration;
    }

    public String getText(String templateName, String parName, Object parValue) {
        return this.getText(templateName, Collections.singletonMap(parName, parValue));
    }

    public String getText(String templateName, Map<String, Object> parameters) {
        try {
            Template template = this.getTemplate(templateName);
            StringWriter writer = new StringWriter();
            template.process(parameters, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed text creation for template " + templateName, e);
        }
    }

    protected Template getTemplate(String templateName) throws IOException {
        Configuration configuration = AbstractMailer.getEngineConfiguration();
        Template template = configuration.getTemplate(templateName);
        return template;
    }

    public Iterable<User> codelistTeam(String codelistId) {
        return (Iterable)this.userRepository.get((Query)UserQueries.teamFor((String)codelistId));
    }

    public Iterable<User> usersWithRole(Role role) {
        return (Iterable)this.userRepository.get((Query)UserQueries.usersWith((Role)role));
    }

    public void sendMail(Collection<String> recipients, String subject, String messageBody) {
        if (recipients.isEmpty()) {
            log.warn("no recepients for email: {}. Send aborted.", (Object)subject);
        } else {
            this.mailService.sendMessage(recipients, subject, messageBody);
        }
    }

    static {
        log = LoggerFactory.getLogger(AbstractMailer.class);
    }

    static class ObjectWrapperExtension
    extends DefaultObjectWrapper {
        ObjectWrapperExtension() {
        }

        protected TemplateModel handleUnknownType(Object obj) throws TemplateModelException {
            return new ReflectionHashModel(obj);
        }

        class ReflectionHashModel
        implements TemplateHashModelEx {
            protected Object object;
            protected Map<String, Method> methodsCache;

            public ReflectionHashModel(Object object) {
                this.object = object;
                this.methodsCache = new HashMap<String, Method>();
                for (Method method : object.getClass().getMethods()) {
                    if (method.getParameterTypes().length != 0) continue;
                    this.methodsCache.put(method.getName(), method);
                }
            }

            public TemplateModel get(String key) throws TemplateModelException {
                try {
                    Method method = this.methodsCache.get(key);
                    Object result = method.invoke(this.object, new Object[0]);
                    return ObjectWrapper.DEFAULT_WRAPPER.wrap(result);
                }
                catch (Exception e) {
                    throw new TemplateModelException("Method invocation error for name " + key, e);
                }
            }

            public boolean isEmpty() throws TemplateModelException {
                return this.methodsCache.isEmpty();
            }

            public int size() throws TemplateModelException {
                return this.methodsCache.size();
            }

            public TemplateCollectionModel keys() throws TemplateModelException {
                return new SimpleCollection(this.methodsCache.keySet());
            }

            public TemplateCollectionModel values() throws TemplateModelException {
                return new SimpleCollection(Collections.emptyList());
            }
        }
    }
}

