/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.cotrix.application.VersioningService;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.Version;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.Roles;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.repository.UserRepository;
import org.cotrix.test.ApplicationTest;
import org.cotrix.test.TestUser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VersioningServiceTest
extends ApplicationTest {
    @Inject
    VersioningService service;
    @Inject
    CodelistRepository codelists;
    @Inject
    TestUser currentUser;
    @Inject
    UserRepository users;
    @Inject
    Event<Version> events;
    Codelist list = (Codelist)((CodelistGrammar.SecondClause)Data.codelist().name("test")).build();

    @Before
    public void before() {
        this.codelists.add((Object)this.list);
        User jimmy = Users.user().name("jimmy").fullName("Jimmy The Manager").noMail().is(new Role[]{Roles.OWNER.on(this.list.id())}).build();
        this.currentUser.set(jimmy);
        this.users.add((Object)jimmy);
    }

    @Test
    public void codelistCanBeVersioned() {
        String version = this.list.version();
        Assert.assertFalse((boolean)version.equals("2014"));
        Codelist versioned = this.service.bump(this.list).to("2014");
        Assert.assertEquals((Object)"2014", (Object)versioned.version());
    }

    @Test
    public void versioningPropagatesPermissions() {
        Codelist versioned = this.service.bump(this.list).to("2014");
        Assert.assertEquals((Object)"2014", (Object)versioned.version());
        User persisted = (User)this.users.lookup(this.currentUser.id());
        Assert.assertTrue((boolean)persisted.is(Roles.OWNER.on(versioned.id())));
    }
}

