/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.impl.news;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.cotrix.application.NewsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultNewsService
implements NewsService {
    private static final Logger log = LoggerFactory.getLogger(NewsService.class);
    private static final int NEWS_SIZE = 20;
    private final LinkedHashMap<Integer, NewsService.NewsItem> news = new LinkedHashMap<Integer, NewsService.NewsItem>(20){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, NewsService.NewsItem> eldest) {
            return this.size() > 20;
        }
    };

    @Override
    public synchronized Collection<NewsService.NewsItem> news() {
        return this.news.values();
    }

    @Override
    public synchronized Collection<NewsService.NewsItem> newsSince(Calendar date) {
        ArrayList<NewsService.NewsItem> recent = new ArrayList<NewsService.NewsItem>();
        for (NewsService.NewsItem item : this.news.values()) {
            if (!item.after(date)) continue;
            recent.add(item);
        }
        return recent;
    }

    private synchronized void monitor(@Observes NewsService.NewsItem item) {
        log.info("publishing news item " + item);
        this.news.put(item.hashCode(), item);
    }
}

