/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.logbook;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import org.cotrix.application.logbook.LogbookEvent;

public class Logbook
implements Serializable {
    private final String resourceId;
    private final List<Entry> entries;

    public Logbook(String resourceId) {
        this(resourceId, new ArrayList<Entry>());
    }

    public Logbook(String resourceId, List<Entry> entries) {
        this.resourceId = resourceId;
        this.entries = entries;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public synchronized List<Entry> entries() {
        return this.entries;
    }

    public synchronized List<Entry> entries(LogbookEvent event) {
        ArrayList<Entry> matches = new ArrayList<Entry>();
        for (Entry e : this.entries) {
            if (e.event != event) continue;
            matches.add(e);
        }
        return matches;
    }

    public synchronized Logbook add(Entry ... es) {
        this.entries.addAll(Arrays.asList(es));
        return this;
    }

    public synchronized Entry find(String id) {
        for (Entry entry : this.entries) {
            if (!entry.id.equals(id)) continue;
            return entry;
        }
        return null;
    }

    public synchronized boolean remove(Entry e) {
        return this.entries.remove(e);
    }

    public String toString() {
        return "Logbook [resourceId=" + this.resourceId + ", entries=" + this.entries + "]";
    }

    public static class Entry
    implements Serializable {
        private final String id = UUID.randomUUID().toString();
        private final String timestamp = DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime());
        private final LogbookEvent event;
        private String description;
        private final String user;
        private final boolean removable;

        Entry(LogbookEvent event, String user, boolean removable) {
            this.event = event;
            this.user = user;
            this.removable = removable;
        }

        public Entry description(String description) {
            this.description = description;
            return this;
        }

        public String id() {
            return this.id;
        }

        public boolean isRemovable() {
            return this.removable;
        }

        public String description() {
            return this.description;
        }

        public String timestamp() {
            return this.timestamp;
        }

        public LogbookEvent event() {
            return this.event;
        }

        public String user() {
            return this.user;
        }

        public String toString() {
            return "Entry [timestamp=" + this.timestamp + ", event=" + (Object)((Object)this.event) + ", description=" + this.description + ", user=" + this.user + "]";
        }
    }
}

