/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.validation;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.application.ValidationService;
import org.cotrix.application.validation.Validator;
import org.cotrix.application.validation.Violation;
import org.cotrix.common.CommonUtils;
import org.cotrix.common.async.CancelledTaskException;
import org.cotrix.common.async.TaskContext;
import org.cotrix.common.async.TaskUpdate;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Containers;
import org.cotrix.domain.common.Status;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.utils.DomainUtils;
import org.cotrix.repository.CodelistQueries;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.repository.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultValidationService
implements ValidationService {
    private static Logger log = LoggerFactory.getLogger(DefaultValidationService.class);
    private static Type type = new TypeToken<List<Violation>>(){}.getType();
    @Inject
    private CodelistRepository codelists;
    @Inject
    private Validator validator;

    public void checkPunctual(Codelist.Private changeset) {
        Codelist list = (Codelist)this.codelists.lookup(changeset.id());
        ArrayList<String> ids = new ArrayList<String>();
        for (Code.Private change : changeset.codes()) {
            if (change.status() == Status.DELETED) continue;
            ids.add(change.id());
        }
        for (Code code : (Iterable)this.codelists.get((Query)CodelistQueries.codes(ids))) {
            this.check(list, Data.reveal((Code)code));
        }
    }

    @Override
    public void validate(Codelist list) {
        long time = System.currentTimeMillis();
        TaskContext context = new TaskContext();
        float progress = 0.0f;
        Containers.Codes codes = Data.reveal((Codelist)list).codes();
        int total = list.codes().size();
        long step = Math.round(Math.max(10.0, Math.floor(codes.size() / 10)));
        int i = 0;
        for (Code.Private code : codes) {
            this.check(list, code);
            progress += 1.0f;
            if ((long)(++i) % step != 0L) continue;
            if (context.isCancelled()) {
                log.info("codelist validation aborted on user request after {} codes.", (Object)i);
                throw new CancelledTaskException("codelist validation aborted on user request");
            }
            context.save((Object)TaskUpdate.update((float)(progress / (float)total), (String)("validated " + i + " codes")));
        }
        log.trace("validated {} in {} msec.", (Object)DomainUtils.signatureOf((Codelist)list), (Object)(System.currentTimeMillis() - time));
    }

    private void check(Codelist list, Code.Private code) {
        List<Violation> violations = this.validator.check(list, (Code)code);
        if (violations.isEmpty()) {
            CommonDefinition.INVALID.removeFrom((Described)code);
            return;
        }
        Containers.Attributes attributes = code.attributes();
        if (CommonDefinition.INVALID.isIn(attributes)) {
            List existingViolations = (List)CommonUtils.jsonBinder().fromJson(CommonDefinition.INVALID.in(attributes), type);
            for (Violation violation : existingViolations) {
                if (!violations.remove(violation)) continue;
                violations.add(violation);
            }
            Collections.sort(violations);
        }
        CommonDefinition.INVALID.set(CommonUtils.jsonBinder().toJson(violations, type)).in(attributes);
    }
}

