/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Singleton;
import org.cotrix.application.validation.Violation;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.attributes.Facet;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Containers;
import org.cotrix.domain.links.Link;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.trait.Definition;
import org.cotrix.domain.validation.Constraint;

@Singleton
public class Validator {
    static String nameViolation = "code has no name.";
    static String occurrenceViolation = "%s occurs %s time(s), violating occurences constraint [%s]";
    static String valueViolation = "%s's value '%s' violates constraint [%s]";

    public List<Violation> check(Codelist list, Code code) {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        if (code.qname().getLocalPart().isEmpty()) {
            violations.add(new Violation(nameViolation));
        }
        this.checkAttributes(violations, list.attributeDefinitions(), code.attributes());
        this.checkLinks(violations, list.linkDefinitions(), code.links());
        return violations;
    }

    private void checkAttributes(List<Violation> violations, Containers.AttributeDefinitions defs, Containers.Attributes attributes) {
        HashMap<String, AttributeDefinition> defmap = new HashMap<String, AttributeDefinition>();
        HashMap<String, Integer> cards = new HashMap<String, Integer>();
        for (AttributeDefinition def : defs) {
            defmap.put(def.id(), def);
            cards.put(def.id(), 0);
        }
        for (Attribute attr : attributes) {
            if (!attr.is(Facet.VALIDATABLE)) continue;
            AttributeDefinition def = (AttributeDefinition)attr.definition();
            Integer card = (Integer)cards.get(def.id());
            if (card != null) {
                cards.put(def.id(), card + 1);
            }
            for (Constraint constraint : def.valueType().constraints()) {
                if (constraint.isMetBy(attr.value())) continue;
                Violation v = Violation.violation(attr);
                v.description(String.format(valueViolation, def.qname(), attr.value(), constraint));
                violations.add(v);
            }
        }
        for (AttributeDefinition def : defmap.values()) {
            if (def.range().inRange(((Integer)cards.get(def.id())).intValue())) continue;
            Violation v = Violation.violation((Definition)def);
            v.description(String.format(occurrenceViolation, def.qname(), cards.get(def.id()), def.range()));
            violations.add(v);
        }
    }

    private void checkLinks(List<Violation> violations, Containers.LinkDefinitions defs, Containers.Links links) {
        HashMap<String, LinkDefinition> defmap = new HashMap<String, LinkDefinition>();
        HashMap<String, Integer> cards = new HashMap<String, Integer>();
        for (LinkDefinition def : defs) {
            defmap.put(def.id(), def);
            cards.put(def.id(), 0);
        }
        for (Link attr : links) {
            LinkDefinition def = (LinkDefinition)attr.definition();
            Integer card = (Integer)cards.get(def.id());
            if (card == null) continue;
            cards.put(def.id(), card + 1);
        }
        for (LinkDefinition def : defmap.values()) {
            if (def.range().inRange(((Integer)cards.get(def.id())).intValue())) continue;
            Violation v = Violation.violation((Definition)def);
            v.description(String.format(occurrenceViolation, def.qname(), cards.get(def.id()), def.range()));
            violations.add(v);
        }
    }
}

