/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import javax.inject.Inject;
import org.cotrix.application.ValidationService;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Ranges;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.grammar.AttributeDefinitionGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.validation.Constraint;
import org.cotrix.domain.validation.Validators;
import org.cotrix.domain.values.ValueType;
import org.cotrix.repository.CodelistActions;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.test.ApplicationTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValidationTest
extends ApplicationTest {
    ValueType type = Data.valueType().with(new Constraint[]{Validators.max_length.instance(new Object[]{2})});
    AttributeDefinition def = (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.attrdef().name("def")).occurs(Ranges.once).valueIs(this.type).build();
    Attribute a = (Attribute)Data.attribute().instanceOf(this.def).value("ss").build();
    Code code = (Code)((CodeGrammar.SecondClause)((CodeGrammar.SecondClause)Data.code().name("c")).attributes(new Attribute[]{this.a})).build();
    Codelist list = (Codelist)((CodelistGrammar.SecondClause)Data.codelist().name("l")).definitions(new AttributeDefinition[]{this.def}).with(new Code[]{this.code}).build();
    @Inject
    CodelistRepository codelists;
    @Inject
    ValidationService validator;

    @Before
    public void versionList() {
        this.codelists.add((Object)this.list);
    }

    @Test
    public void attributesAreValidatedOnUpdate() {
        Attribute onetoomany = (Attribute)Data.attribute().instanceOf(this.def).build();
        Attribute moda = (Attribute)Data.modify((Attribute)this.a).value("toolong").build();
        Code modified = (Code)((CodeGrammar.SecondClause)Data.modify((Code)this.code).attributes(new Attribute[]{onetoomany, moda})).build();
        this.codelists.update(Data.modify((Codelist)this.list).with(new Code[]{modified}).build());
        Assert.assertNotNull((Object)CommonDefinition.INVALID.of((Described)this.code));
        modified = (Code)((CodeGrammar.SecondClause)Data.modify((Code)this.code).attributes(new Attribute[]{Data.delete((Attribute)onetoomany), (Attribute)Data.modify((Attribute)this.a).value("ss").build()})).build();
        this.codelists.update(Data.modify((Codelist)this.list).with(new Code[]{modified}).build());
        Assert.assertNull((Object)CommonDefinition.INVALID.of((Described)this.code));
    }

    @Test
    public void missingAAttributesAreDetectedOnUpdate() {
        Code modified = (Code)((CodeGrammar.SecondClause)Data.modify((Code)this.code).attributes(new Attribute[]{Data.delete((Attribute)this.a)})).build();
        this.codelists.update(Data.modify((Codelist)this.list).with(new Code[]{modified}).build());
        System.out.println(CommonDefinition.INVALID.of((Described)this.code));
    }

    @Test
    public void attributesAreValidatedWhenDefinitionsChange() {
        AttributeDefinition moddef = (AttributeDefinition)Data.modify((AttributeDefinition)this.def).valueIs((ValueType)Data.valueType().with(new Constraint[]{Validators.number.instance(new Object[0])})).build();
        this.codelists.update(Data.modify((Codelist)this.list).definitions(new AttributeDefinition[]{moddef}).build());
        this.validator.validate(this.list);
        System.out.println(CommonDefinition.INVALID.of((Described)this.code));
    }

    @Test
    public void attributesAreValidatedWhenDefinitionsAreRemoved() {
        Attribute onetoomany = (Attribute)Data.attribute().instanceOf(this.def).build();
        Attribute moda = (Attribute)Data.modify((Attribute)this.a).value("toolong").build();
        Code modified = (Code)((CodeGrammar.SecondClause)Data.modify((Code)this.code).attributes(new Attribute[]{onetoomany, moda})).build();
        this.codelists.update(Data.modify((Codelist)this.list).with(new Code[]{modified}).build());
        this.validator.validate(this.list);
        Assert.assertNotNull((Object)CommonDefinition.INVALID.of((Described)this.code));
        this.codelists.update(this.list.id(), CodelistActions.deleteAttrdef((String)this.def.id()));
        this.validator.validate(this.list);
        Assert.assertNull((Object)CommonDefinition.INVALID.of((Described)this.code));
    }
}

