/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.common;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class Utils {
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");

    public static void notNull(String name, Object o) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException(name + " is null");
        }
    }

    public static void notNulls(String name, Object[] o) throws IllegalArgumentException {
        Utils.notNull(name, o);
        for (Object ob : o) {
            Utils.notNull("one of " + name, ob);
        }
    }

    public static void notEmpty(String name, String s) throws IllegalArgumentException {
        if (s.isEmpty()) {
            throw new IllegalArgumentException(name + " is empty");
        }
    }

    public static void notEmpty(String name, Object[] a) throws IllegalArgumentException {
        Utils.notNull(name, a);
        if (a.length == 0) {
            throw new IllegalArgumentException(name + " is empty");
        }
    }

    public static void valid(String name, String s) throws IllegalArgumentException {
        Utils.notNull(name, s);
        Utils.notEmpty(name, s);
    }

    public static void notEmpty(String name, Collection<? extends Object> c) throws IllegalArgumentException {
        if (c.isEmpty()) {
            throw new IllegalArgumentException(name + " is empty");
        }
    }

    public static void valid(String name, Collection<String> c) throws IllegalArgumentException {
        Utils.notNull(name, c);
        Utils.notEmpty(name, c);
        for (String e : c) {
            Utils.valid(name + "'s element", e);
        }
    }

    public static void valid(String name, Object[] a) throws IllegalArgumentException {
        Utils.notNull(name, a);
        for (Object e : a) {
            Utils.notNull(name + "'s element", e);
        }
    }

    public static void valid(String text, QName name) throws IllegalArgumentException {
        Utils.notNull(text, name);
        Utils.valid(text, name.getLocalPart());
    }

    public static QName copyName(QName name) {
        return new QName(name.getNamespaceURI(), name.getLocalPart());
    }

    public static <T> T reveal(Object o, Class<T> type) {
        Utils.notNull("object", o);
        try {
            return type.cast(o);
        }
        catch (ClassCastException e) {
            throw new AssertionError((Object)("expected a " + type + ", found instead a " + o.getClass()));
        }
    }

    public static <PUBLIC, PRIVATE extends PUBLIC> List<PRIVATE> revealAll(Iterable<? extends PUBLIC> objects, Class<PRIVATE> privateClass) {
        Utils.notNull("objects", objects);
        ArrayList<PRIVATE> privates = new ArrayList<PRIVATE>();
        for (PUBLIC publicObject : objects) {
            privates.add(Utils.reveal(publicObject, privateClass));
        }
        return privates;
    }

    public static void valid(File file) throws IllegalArgumentException {
        if (!Utils.isValid(file)) {
            throw new IllegalArgumentException(file + " does not exist, is a directory, or cannot be read");
        }
    }

    public static boolean isValid(File file) {
        Utils.notNull("file", file);
        return file.exists() && file.isDirectory() && file.canRead();
    }

    public static void validDirectory(File dir) throws IllegalArgumentException {
        if (!Utils.isValidDirectory(dir)) {
            throw new IllegalArgumentException(dir + " does not exist or cannot be read");
        }
    }

    public static boolean isValidDirectory(File dir) {
        Utils.notNull("directory", dir);
        return dir.exists() && dir.canRead();
    }

    public static void validEmail(String email) {
        if (!pattern.matcher(email).matches()) {
            throw new IllegalArgumentException("invalid email address " + email);
        }
    }

    public static RuntimeException unchecked(Throwable t) {
        return Utils.unchecked(t.getMessage() + "( unchecked wrapper )", t);
    }

    public static RuntimeException unchecked(String msg, Throwable t) {
        return t instanceof RuntimeException ? (RuntimeException)RuntimeException.class.cast(t) : new RuntimeException(msg, t);
    }

    public static void rethrowUnchecked(Throwable t) throws RuntimeException {
        throw Utils.unchecked(t);
    }

    public static void rethrow(String msg, Throwable t) throws RuntimeException {
        throw Utils.unchecked(msg, t);
    }

    public static <T> Collection<T> collect(Iterable<T> it) {
        ArrayList<T> c = new ArrayList<T>();
        for (T t : it) {
            c.add(t);
        }
        return c;
    }

    public static void assertEqualUnordered(Collection<?> c1, Object ... ts) {
        HashSet s1 = new HashSet(c1);
        HashSet<Object> s2 = new HashSet<Object>(Arrays.asList(ts));
        if (!s2.equals(s1)) {
            throw new AssertionError((Object)("expected " + s2 + " but was " + s1));
        }
    }

    public static void assertEqualOrdered(Collection<?> c1, Object ... ts) {
        ArrayList s1 = new ArrayList(c1);
        List<Object> s2 = Arrays.asList(ts);
        if (!s2.equals(s1)) {
            throw new AssertionError((Object)("expected " + s2 + " but was " + s1));
        }
    }

    public static <T> int count(Iterable<T> elements) {
        return Utils.count(elements.iterator());
    }

    public static <T> int count(Iterator<T> elements) {
        int count = 0;
        while (elements.hasNext()) {
            elements.next();
            ++count;
        }
        return count;
    }
}

