/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.configuration;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.cotrix.common.Utils;
import org.cotrix.configuration.Configuration;
import org.cotrix.configuration.ConfigurationBean;

public class ConfigurationContext {
    private JAXBContext context;

    @Inject
    public ConfigurationContext(Instance<ConfigurationBean> prototypes) {
        ArrayList klasses = new ArrayList();
        for (ConfigurationBean sample : prototypes) {
            klasses.add(sample.getClass());
        }
        try {
            this.context = JAXBContext.newInstance((Class[])klasses.toArray(new Class[0]));
        }
        catch (Exception e) {
            Utils.rethrow((String)"cannot create configuration context (see cause)", (Throwable)e);
        }
    }

    public List<ConfigurationBean> bind(InputStream stream) {
        try {
            Configuration container = (Configuration)this.context.createUnmarshaller().unmarshal(stream);
            return container.beans();
        }
        catch (JAXBException e) {
            throw Utils.unchecked((String)"cannot read configuration (see cause)", (Throwable)e);
        }
    }
}

