/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.dsl.builder;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.builder.BuilderUtils;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.memory.CodelistMS;
import org.cotrix.domain.version.DefaultVersion;
import org.cotrix.domain.version.Version;

public final class CodelistBuilder
implements CodelistGrammar.CodelistNewClause,
CodelistGrammar.CodelistChangeClause,
CodelistGrammar.ThirdClause,
CodelistGrammar.FourthClause,
CodelistGrammar.FinalClause {
    private final CodelistMS state;

    public CodelistBuilder(CodelistMS state) {
        this.state = state;
    }

    @Override
    public CodelistGrammar.SecondClause name(QName name) {
        this.state.name(name);
        return this;
    }

    @Override
    public CodelistGrammar.SecondClause name(String name) {
        return this.name(Codes.q(name));
    }

    @Override
    public CodelistGrammar.ThirdClause with(List<Code> codes) {
        this.state.codes(BuilderUtils.reveal(codes, Code.Private.class));
        return this;
    }

    public CodelistGrammar.ThirdClause with(Code ... codes) {
        return this.with((List)Arrays.asList(codes));
    }

    public CodelistGrammar.FourthClause links(CodelistLink ... links) {
        this.state.links(BuilderUtils.reveal(Arrays.asList(links), CodelistLink.Private.class));
        return this;
    }

    @Override
    public CodelistGrammar.FinalClause attributes(Attribute ... attributes) {
        return this.attributes((List)Arrays.asList(attributes));
    }

    @Override
    public CodelistGrammar.FinalClause attributes(List<Attribute> attributes) {
        this.state.attributes(BuilderUtils.reveal(attributes, Attribute.Private.class));
        return this;
    }

    public CodelistBuilder version(Version version) {
        this.state.version(version);
        return this;
    }

    public CodelistBuilder version(String version) {
        this.state.version(new DefaultVersion(version));
        return this;
    }

    @Override
    public Codelist build() {
        return this.state.entity();
    }
}

