/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.trait;

import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.version.Version;

public interface Versioned {
    public String version();

    public static abstract class Abstract<SELF extends Abstract<SELF, S>, S extends State & Identified.State & Named.State>
    extends Named.Abstract<SELF, S>
    implements Versioned {
        public Abstract(S state) {
            super((Named.State)state);
        }

        @Override
        public String version() {
            return ((State)this.state()).version() == null ? null : ((State)this.state()).version().value();
        }

        @Override
        public void update(SELF changeset) throws IllegalArgumentException, IllegalStateException {
            super.update(changeset);
            if (((Abstract)changeset).version() != null && !((Abstract)changeset).version().equals(this.version())) {
                throw new IllegalArgumentException("cannot change the version (" + this.version() + ") of entity " + this.id() + ". Versioning is performed by copy");
            }
        }

        public void build(S state) {
            state.version(((State)this.state()).version());
        }

        public SELF bump(String version) {
            Version newVersion = ((State)this.state()).version().bumpTo(version);
            SELF copy = this.copyWith(newVersion);
            return copy;
        }

        protected abstract SELF copyWith(Version var1);
    }

    public static interface State {
        public Version version();

        public void version(Version var1);
    }
}

