/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.common;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.cotrix.common.Utils;
import org.cotrix.domain.common.IteratorAdapter;
import org.cotrix.domain.common.StateContainer;
import org.cotrix.domain.trait.EntityProvider;
import org.cotrix.domain.trait.Identified;

public interface Container<T>
extends Iterable<T> {
    public int size();

    public boolean contains(Object var1);

    public boolean contains(String var1);

    public T lookup(String var1) throws IllegalStateException;

    public static class Private<T extends Identified.Abstract<T, S>, S extends Identified.State & EntityProvider<T>>
    extends Abstract<T, S, StateContainer<S>> {
        public Private(StateContainer<S> state) {
            super(state);
        }
    }

    public static abstract class Abstract<T extends Identified.Abstract<T, S>, S extends Identified.State & EntityProvider<T>, C extends StateContainer<S>>
    implements Container<T> {
        private final C state;

        public Abstract(C state) {
            Utils.notNull((String)"state", state);
            this.state = state;
        }

        @Override
        public Iterator<T> iterator() {
            return new IteratorAdapter(this.state.iterator());
        }

        @Override
        public boolean contains(Object entity) {
            Utils.notNull((String)"entity", (Object)entity);
            return entity instanceof Identified.Abstract ? this.state().contains((Identified.State)((Identified.Abstract)Utils.reveal((Object)entity, Identified.Abstract.class)).state()) : false;
        }

        @Override
        public boolean contains(String id) throws IllegalStateException {
            return !this.state().get(Collections.singleton(id)).isEmpty();
        }

        @Override
        public T lookup(String id) throws IllegalStateException {
            Collection matches = this.state().get(Collections.singleton(id));
            if (matches.isEmpty()) {
                throw new IllegalStateException("no entity " + id + " in this container");
            }
            return (T)((Identified.Abstract)((EntityProvider)((Object)((Identified.State)matches.iterator().next()))).entity());
        }

        @Override
        public int size() {
            return this.state.size();
        }

        public void update(Abstract<T, S, C> changeset) {
            HashMap<String, Identified.Abstract> updates = new HashMap<String, Identified.Abstract>();
            for (Identified.Abstract entityChangeset : changeset) {
                String id = entityChangeset.id();
                if (this.state.contains(id)) {
                    if (entityChangeset.status() == null) {
                        throw new IllegalArgumentException("invalid changeset:" + entityChangeset.id() + " cannot be added twice");
                    }
                    switch (entityChangeset.status()) {
                        case DELETED: {
                            this.state.remove(id);
                            break;
                        }
                        case MODIFIED: {
                            updates.put(entityChangeset.id(), entityChangeset);
                        }
                    }
                    continue;
                }
                this.state.add(entityChangeset.state());
            }
            if (!updates.isEmpty()) {
                for (Identified.State toUpdate : this.state.get(updates.keySet())) {
                    ((Identified.Abstract)((EntityProvider)((Object)toUpdate)).entity()).update((Identified.Abstract)updates.get(toUpdate.id()));
                }
            }
        }

        public C state() {
            return this.state;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Abstract)) {
                return false;
            }
            Abstract other = (Abstract)obj;
            return !(this.state == null ? other.state != null : !this.state.equals(other.state));
        }

        public String toString() {
            int maxLen = 100;
            return "[" + (this.state != null ? this.toString(100) : null) + "]";
        }

        private String toString(int maxLen) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            Iterator<T> iterator = this.iterator();
            for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(iterator.next());
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

