/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.utils;

import java.text.DateFormat;
import java.util.Date;
import javax.xml.namespace.QName;
import org.cotrix.common.Utils;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelink;
import org.cotrix.domain.common.NamedContainer;
import org.cotrix.domain.utils.CodeStatus;
import org.cotrix.domain.utils.Constants;

public class ManagedCode
implements Code {
    private final Code managed;

    public static ManagedCode manage(Code code) {
        return new ManagedCode(code);
    }

    ManagedCode(Code code) {
        this.managed = code;
    }

    public Date created() {
        String val = this.lookup(Constants.CREATION_TIME);
        try {
            return val == null ? null : DateFormat.getDateTimeInstance().parse(val);
        }
        catch (Exception e) {
            throw Utils.unchecked((Throwable)e);
        }
    }

    public String originId() {
        return this.lookup(Constants.PREVIOUS_VERSION_ID);
    }

    public QName originName() {
        String val = this.lookup(Constants.PREVIOUS_VERSION_NAME);
        return val == null ? null : QName.valueOf(val);
    }

    public Date lastUpdated() {
        String val = this.lookup(Constants.UPDATE_TIME);
        try {
            return val == null ? this.created() : DateFormat.getDateTimeInstance().parse(val);
        }
        catch (Exception e) {
            throw Utils.unchecked((Throwable)e);
        }
    }

    public String lastUpdatedBy() {
        String val = this.lookup(Constants.UPDATED_BY);
        return val;
    }

    public CodeStatus status() {
        String val = this.lookup(Constants.STATUS);
        if (val == null) {
            return CodeStatus.VALID;
        }
        return CodeStatus.valueOf(val);
    }

    private String lookup(QName name) {
        return this.managed.attributes().contains(name) ? this.managed.attributes().lookup(name).value() : null;
    }

    @Override
    public String id() {
        return this.managed.id();
    }

    @Override
    public NamedContainer<? extends Attribute> attributes() {
        return this.managed.attributes();
    }

    @Override
    public QName name() {
        return this.managed.name();
    }

    @Override
    public NamedContainer<? extends Codelink> links() {
        return this.managed.links();
    }
}

